@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ClusterEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an RDS Aurora Cluster Endpoint.
 * You can refer to the [User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.Endpoints.html#Aurora.Endpoints.Cluster).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.aws.rds.ClusterEndpoint;
 * import com.pulumi.aws.rds.ClusterEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("aurora-cluster-demo")
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .databaseName("mydb")
 *             .masterUsername("foo")
 *             .masterPassword("bar")
 *             .backupRetentionPeriod(5)
 *             .preferredBackupWindow("07:00-09:00")
 *             .build());
 *         var test1 = new ClusterInstance("test1", ClusterInstanceArgs.builder()
 *             .applyImmediately(true)
 *             .clusterIdentifier(default_.id())
 *             .identifier("test1")
 *             .instanceClass("db.t2.small")
 *             .engine(default_.engine())
 *             .engineVersion(default_.engineVersion())
 *             .build());
 *         var test2 = new ClusterInstance("test2", ClusterInstanceArgs.builder()
 *             .applyImmediately(true)
 *             .clusterIdentifier(default_.id())
 *             .identifier("test2")
 *             .instanceClass("db.t2.small")
 *             .engine(default_.engine())
 *             .engineVersion(default_.engineVersion())
 *             .build());
 *         var test3 = new ClusterInstance("test3", ClusterInstanceArgs.builder()
 *             .applyImmediately(true)
 *             .clusterIdentifier(default_.id())
 *             .identifier("test3")
 *             .instanceClass("db.t2.small")
 *             .engine(default_.engine())
 *             .engineVersion(default_.engineVersion())
 *             .build());
 *         var eligible = new ClusterEndpoint("eligible", ClusterEndpointArgs.builder()
 *             .clusterIdentifier(default_.id())
 *             .clusterEndpointIdentifier("reader")
 *             .customEndpointType("READER")
 *             .excludedMembers(
 *                 test1.id(),
 *                 test2.id())
 *             .build());
 *         var static_ = new ClusterEndpoint("static", ClusterEndpointArgs.builder()
 *             .clusterIdentifier(default_.id())
 *             .clusterEndpointIdentifier("static")
 *             .customEndpointType("READER")
 *             .staticMembers(
 *                 test1.id(),
 *                 test3.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RDS Clusters Endpoint using the `cluster_endpoint_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:rds/clusterEndpoint:ClusterEndpoint custom_reader aurora-prod-cluster-custom-reader
 * ```
 * @property clusterEndpointIdentifier The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
 * @property clusterIdentifier The cluster identifier.
 * @property customEndpointType The type of the endpoint. One of: READER , ANY .
 * @property excludedMembers List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty. Conflicts with `static_members`.
 * @property staticMembers List of DB instance identifiers that are part of the custom endpoint group. Conflicts with `excluded_members`.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterEndpointArgs(
    public val clusterEndpointIdentifier: Output<String>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val customEndpointType: Output<String>? = null,
    public val excludedMembers: Output<List<String>>? = null,
    public val staticMembers: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ClusterEndpointArgs> {
    override fun toJava(): com.pulumi.aws.rds.ClusterEndpointArgs =
        com.pulumi.aws.rds.ClusterEndpointArgs.builder()
            .clusterEndpointIdentifier(clusterEndpointIdentifier?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .customEndpointType(customEndpointType?.applyValue({ args0 -> args0 }))
            .excludedMembers(excludedMembers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .staticMembers(staticMembers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterEndpointArgs].
 */
@PulumiTagMarker
public class ClusterEndpointArgsBuilder internal constructor() {
    private var clusterEndpointIdentifier: Output<String>? = null

    private var clusterIdentifier: Output<String>? = null

    private var customEndpointType: Output<String>? = null

    private var excludedMembers: Output<List<String>>? = null

    private var staticMembers: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
     */
    @JvmName("iowvlwkftnsgqvmm")
    public suspend fun clusterEndpointIdentifier(`value`: Output<String>) {
        this.clusterEndpointIdentifier = value
    }

    /**
     * @param value The cluster identifier.
     */
    @JvmName("hwbpnmjorqxbubqq")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The type of the endpoint. One of: READER , ANY .
     */
    @JvmName("fyhghbepqgqjubfr")
    public suspend fun customEndpointType(`value`: Output<String>) {
        this.customEndpointType = value
    }

    /**
     * @param value List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty. Conflicts with `static_members`.
     */
    @JvmName("lgmkufqrnjyaahrv")
    public suspend fun excludedMembers(`value`: Output<List<String>>) {
        this.excludedMembers = value
    }

    @JvmName("esedptcthyliaymc")
    public suspend fun excludedMembers(vararg values: Output<String>) {
        this.excludedMembers = Output.all(values.asList())
    }

    /**
     * @param values List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty. Conflicts with `static_members`.
     */
    @JvmName("lrpmfmrdxshgpekx")
    public suspend fun excludedMembers(values: List<Output<String>>) {
        this.excludedMembers = Output.all(values)
    }

    /**
     * @param value List of DB instance identifiers that are part of the custom endpoint group. Conflicts with `excluded_members`.
     */
    @JvmName("jykfyxokphbbseio")
    public suspend fun staticMembers(`value`: Output<List<String>>) {
        this.staticMembers = value
    }

    @JvmName("uxbqlnnjiumobbok")
    public suspend fun staticMembers(vararg values: Output<String>) {
        this.staticMembers = Output.all(values.asList())
    }

    /**
     * @param values List of DB instance identifiers that are part of the custom endpoint group. Conflicts with `excluded_members`.
     */
    @JvmName("ryaiaigijovflnpm")
    public suspend fun staticMembers(values: List<Output<String>>) {
        this.staticMembers = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lulprlkudhojfjqh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
     */
    @JvmName("rxkacmtfxkrgwbnc")
    public suspend fun clusterEndpointIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterEndpointIdentifier = mapped
    }

    /**
     * @param value The cluster identifier.
     */
    @JvmName("apywtqrijvnfcxns")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The type of the endpoint. One of: READER , ANY .
     */
    @JvmName("dwfrdtvvnoufyfwf")
    public suspend fun customEndpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEndpointType = mapped
    }

    /**
     * @param value List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty. Conflicts with `static_members`.
     */
    @JvmName("bwbwfpehpsmrxurq")
    public suspend fun excludedMembers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedMembers = mapped
    }

    /**
     * @param values List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty. Conflicts with `static_members`.
     */
    @JvmName("lwisurrpdyoqhsho")
    public suspend fun excludedMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedMembers = mapped
    }

    /**
     * @param value List of DB instance identifiers that are part of the custom endpoint group. Conflicts with `excluded_members`.
     */
    @JvmName("fxxbgldrspqefdwf")
    public suspend fun staticMembers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticMembers = mapped
    }

    /**
     * @param values List of DB instance identifiers that are part of the custom endpoint group. Conflicts with `excluded_members`.
     */
    @JvmName("cijqkecorhvjcoxs")
    public suspend fun staticMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.staticMembers = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("asqsgfmdmiyxbuem")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oqnbsdkjjtvbaphn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterEndpointArgs = ClusterEndpointArgs(
        clusterEndpointIdentifier = clusterEndpointIdentifier,
        clusterIdentifier = clusterIdentifier,
        customEndpointType = customEndpointType,
        excludedMembers = excludedMembers,
        staticMembers = staticMembers,
        tags = tags,
    )
}
