@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ClusterInstance].
 */
@PulumiTagMarker
public class ClusterInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterInstanceArgs = ClusterInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterInstanceArgsBuilder.() -> Unit) {
        val builder = ClusterInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ClusterInstance {
        val builtJavaResource = com.pulumi.aws.rds.ClusterInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterInstance(builtJavaResource)
    }
}

/**
 * Provides an RDS Cluster Instance Resource. A Cluster Instance Resource defines
 * attributes that are specific to a single instance in a RDS Cluster,
 * specifically running Amazon Aurora.
 * Unlike other RDS resources that support replication, with Amazon Aurora you do
 * not designate a primary and subsequent replicas. Instead, you simply add RDS
 * Instances and Aurora manages the replication. You can use the [count][5]
 * meta-parameter to make multiple instances and join them all to the same RDS
 * Cluster, or you may specify different Cluster Instance resources with various
 * `instance_class` sizes.
 * For more information on Amazon Aurora, see [Aurora on Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html) in the Amazon RDS User Guide.
 * > **NOTE:** Deletion Protection from the RDS service can only be enabled at the cluster level, not for individual cluster instances. You can still add the [`protect` CustomResourceOption](https://www.pulumi.com/docs/intro/concepts/programming-model/#protect) to this resource configuration if you desire protection from accidental deletion.
 * > **NOTE:** `aurora` is no longer a valid `engine` because of [Amazon Aurora's MySQL-Compatible Edition version 1 end of life](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.MySQL56.EOL.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("aurora-cluster-demo")
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .databaseName("mydb")
 *             .masterUsername("foo")
 *             .masterPassword("barbut8chars")
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new ClusterInstance("clusterInstances-" + i, ClusterInstanceArgs.builder()
 *                 .identifier(String.format("aurora-cluster-demo-%s", range.value()))
 *                 .clusterIdentifier(default_.id())
 *                 .instanceClass("db.r4.large")
 *                 .engine(default_.engine())
 *                 .engineVersion(default_.engineVersion())
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RDS Cluster Instances using the `identifier`. For example:
 * ```sh
 *  $ pulumi import aws:rds/clusterInstance:ClusterInstance prod_instance_1 aurora-cluster-instance-1
 * ```
 *
 */
public class ClusterInstance internal constructor(
    override val javaResource: com.pulumi.aws.rds.ClusterInstance,
) : KotlinCustomResource(javaResource, ClusterInstanceMapper) {
    /**
     * Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
     */
    public val applyImmediately: Output<Boolean>
        get() = javaResource.applyImmediately().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of cluster instance
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
     */
    public val autoMinorVersionUpgrade: Output<Boolean>?
        get() = javaResource.autoMinorVersionUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * Identifier of the CA certificate for the DB instance.
     */
    public val caCertIdentifier: Output<String>
        get() = javaResource.caCertIdentifier().applyValue({ args0 -> args0 })

    /**
     * Identifier of the `aws.rds.Cluster` in which to launch this instance.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
     */
    public val copyTagsToSnapshot: Output<Boolean>?
        get() = javaResource.copyTagsToSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
     */
    public val customIamInstanceProfile: Output<String>?
        get() = javaResource.customIamInstanceProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the DB parameter group to associate with this instance.
     */
    public val dbParameterGroupName: Output<String>
        get() = javaResource.dbParameterGroupName().applyValue({ args0 -> args0 })

    /**
     * DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` of the attached `aws.rds.Cluster`.
     */
    public val dbSubnetGroupName: Output<String>
        get() = javaResource.dbSubnetGroupName().applyValue({ args0 -> args0 })

    /**
     * Region-unique, immutable identifier for the DB instance.
     */
    public val dbiResourceId: Output<String>
        get() = javaResource.dbiResourceId().applyValue({ args0 -> args0 })

    /**
     * DNS address for this instance. May not be writable
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * Name of the database engine to be used for the RDS cluster instance.
     * Valid Values: `aurora-mysql`, `aurora-postgresql`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * Database engine version.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Database engine version
     */
    public val engineVersionActual: Output<String>
        get() = javaResource.engineVersionActual().applyValue({ args0 -> args0 })

    /**
     * Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
     */
    public val identifier: Output<String>
        get() = javaResource.identifier().applyValue({ args0 -> args0 })

    /**
     * Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    public val identifierPrefix: Output<String>
        get() = javaResource.identifierPrefix().applyValue({ args0 -> args0 })

    /**
     * Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs&#46;aws&#46;amazon&#46;com/AmazonRDS/latest/UserGuide/Aurora&#46;Managing&#46;html)&#46; Aurora uses `db&#46;*` instance classes/types&#46; Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details.
     */
    public val instanceClass: Output<String>
        get() = javaResource.instanceClass().applyValue({ args0 -> args0 })

    /**
     * ARN for the KMS encryption key if one is set to the cluster.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
     */
    public val monitoringInterval: Output<Int>?
        get() = javaResource.monitoringInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
     */
    public val monitoringRoleArn: Output<String>
        get() = javaResource.monitoringRoleArn().applyValue({ args0 -> args0 })

    /**
     * Network type of the DB instance.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * Specifies whether Performance Insights is enabled or not.
     */
    public val performanceInsightsEnabled: Output<Boolean>
        get() = javaResource.performanceInsightsEnabled().applyValue({ args0 -> args0 })

    /**
     * ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
     */
    public val performanceInsightsKmsKeyId: Output<String>
        get() = javaResource.performanceInsightsKmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
     */
    public val performanceInsightsRetentionPeriod: Output<Int>
        get() = javaResource.performanceInsightsRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * Database port
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * Daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00". **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
     */
    public val preferredBackupWindow: Output<String>
        get() = javaResource.preferredBackupWindow().applyValue({ args0 -> args0 })

    /**
     * Window to perform maintenance in. Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
     */
    public val preferredMaintenanceWindow: Output<String>
        get() = javaResource.preferredMaintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
     */
    public val promotionTier: Output<Int>?
        get() = javaResource.promotionTier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
     */
    public val publiclyAccessible: Output<Boolean>
        get() = javaResource.publiclyAccessible().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the DB cluster is encrypted.
     */
    public val storageEncrypted: Output<Boolean>
        get() = javaResource.storageEncrypted().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
     */
    public val writer: Output<Boolean>
        get() = javaResource.writer().applyValue({ args0 -> args0 })
}

public object ClusterInstanceMapper : ResourceMapper<ClusterInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ClusterInstance::class == javaResource::class

    override fun map(javaResource: Resource): ClusterInstance = ClusterInstance(
        javaResource as
            com.pulumi.aws.rds.ClusterInstance,
    )
}

/**
 * @see [ClusterInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterInstance].
 */
public suspend fun clusterInstance(
    name: String,
    block: suspend ClusterInstanceResourceBuilder.() -> Unit,
): ClusterInstance {
    val builder = ClusterInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterInstance(name: String): ClusterInstance {
    val builder = ClusterInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
