@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CustomDbEngineVersion].
 */
@PulumiTagMarker
public class CustomDbEngineVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomDbEngineVersionArgs = CustomDbEngineVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomDbEngineVersionArgsBuilder.() -> Unit) {
        val builder = CustomDbEngineVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomDbEngineVersion {
        val builtJavaResource = com.pulumi.aws.rds.CustomDbEngineVersion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomDbEngineVersion(builtJavaResource)
    }
}

/**
 * Provides an custom engine version (CEV) resource for Amazon RDS Custom. For additional information, see [Working with CEVs for RDS Custom for Oracle](https://docs&#46;aws&#46;amazon&#46;com/AmazonRDS/latest/UserGuide/custom-cev&#46;html) and [Working with CEVs for RDS Custom for SQL Server](https://docs&#46;aws&#46;amazon&#46;com/AmazonRDS/latest/UserGuide/custom-cev-sqlserver&#46;html) in the the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html).
 * ## Example Usage
 * ### RDS Custom for Oracle Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.CustomDbEngineVersion;
 * import com.pulumi.aws.rds.CustomDbEngineVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("KMS symmetric key for RDS Custom for Oracle")
 *             .build());
 *         var exampleCustomDbEngineVersion = new CustomDbEngineVersion("exampleCustomDbEngineVersion", CustomDbEngineVersionArgs.builder()
 *             .databaseInstallationFilesS3BucketName("DOC-EXAMPLE-BUCKET")
 *             .databaseInstallationFilesS3Prefix("1915_GI/")
 *             .engine("custom-oracle-ee-cdb")
 *             .engineVersion("19.cdb_cev1")
 *             .kmsKeyId(exampleKey.arn())
 *             .manifest("""
 *   {
 * 	"databaseInstallationFileNames":["V982063-01.zip"]
 *   }
 *             """)
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### RDS Custom for Oracle External Manifest Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.CustomDbEngineVersion;
 * import com.pulumi.aws.rds.CustomDbEngineVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("KMS symmetric key for RDS Custom for Oracle")
 *             .build());
 *         var exampleCustomDbEngineVersion = new CustomDbEngineVersion("exampleCustomDbEngineVersion", CustomDbEngineVersionArgs.builder()
 *             .databaseInstallationFilesS3BucketName("DOC-EXAMPLE-BUCKET")
 *             .databaseInstallationFilesS3Prefix("1915_GI/")
 *             .engine("custom-oracle-ee-cdb")
 *             .engineVersion("19.cdb_cev1")
 *             .kmsKeyId(exampleKey.arn())
 *             .filename("manifest_1915_GI.json")
 *             .manifestHash(computeFileBase64Sha256(manifest_1915_GI.json()))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### RDS Custom for SQL Server Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.CustomDbEngineVersion;
 * import com.pulumi.aws.rds.CustomDbEngineVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new CustomDbEngineVersion("test", CustomDbEngineVersionArgs.builder()
 *             .engine("custom-sqlserver-se")
 *             .engineVersion("15.00.4249.2.cev-1")
 *             .sourceImageId("ami-0aa12345678a12ab1")
 *             .build());
 *     }
 * }
 * ```
 * ### RDS Custom for SQL Server Usage with AMI from another region
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiCopy;
 * import com.pulumi.aws.ec2.AmiCopyArgs;
 * import com.pulumi.aws.rds.CustomDbEngineVersion;
 * import com.pulumi.aws.rds.CustomDbEngineVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiCopy("example", AmiCopyArgs.builder()
 *             .description("A copy of ami-xxxxxxxx")
 *             .sourceAmiId("ami-xxxxxxxx")
 *             .sourceAmiRegion("us-east-1")
 *             .build());
 *         var test = new CustomDbEngineVersion("test", CustomDbEngineVersionArgs.builder()
 *             .engine("custom-sqlserver-se")
 *             .engineVersion("15.00.4249.2.cev-1")
 *             .sourceImageId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import custom engine versions for Amazon RDS custom using the `engine` and `engine_version` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:rds/customDbEngineVersion:CustomDbEngineVersion example custom-oracle-ee-cdb:19.cdb_cev1
 * ```
 *
 */
public class CustomDbEngineVersion internal constructor(
    override val javaResource: com.pulumi.aws.rds.CustomDbEngineVersion,
) : KotlinCustomResource(javaResource, CustomDbEngineVersionMapper) {
    /**
     * The Amazon Resource Name (ARN) for the custom engine version.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time that the CEV was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The name of the Amazon S3 bucket that contains the database installation files.
     */
    public val databaseInstallationFilesS3BucketName: Output<String>?
        get() = javaResource.databaseInstallationFilesS3BucketName().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The prefix for the Amazon S3 bucket that contains the database installation files.
     */
    public val databaseInstallationFilesS3Prefix: Output<String>?
        get() = javaResource.databaseInstallationFilesS3Prefix().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The name of the DB parameter group family for the CEV.
     */
    public val dbParameterGroupFamily: Output<String>
        get() = javaResource.dbParameterGroupFamily().applyValue({ args0 -> args0 })

    /**
     * The description of the CEV.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The version of the database engine.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The name of the manifest file within the local filesystem. Conflicts with `manifest`.
     */
    public val filename: Output<String>?
        get() = javaResource.filename().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the AMI that was created with the CEV.
     */
    public val imageId: Output<String>
        get() = javaResource.imageId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The major version of the database engine.
     */
    public val majorEngineVersion: Output<String>
        get() = javaResource.majorEngineVersion().applyValue({ args0 -> args0 })

    /**
     * The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
     */
    public val manifest: Output<String>?
        get() = javaResource.manifest().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The returned manifest file, in JSON format, service generated and often different from input `manifest`.
     */
    public val manifestComputed: Output<String>
        get() = javaResource.manifestComputed().applyValue({ args0 -> args0 })

    /**
     * Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
     */
    public val manifestHash: Output<String>?
        get() = javaResource.manifestHash().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
     */
    public val sourceImageId: Output<String>?
        get() = javaResource.sourceImageId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CustomDbEngineVersionMapper : ResourceMapper<CustomDbEngineVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.CustomDbEngineVersion::class == javaResource::class

    override fun map(javaResource: Resource): CustomDbEngineVersion =
        CustomDbEngineVersion(javaResource as com.pulumi.aws.rds.CustomDbEngineVersion)
}

/**
 * @see [CustomDbEngineVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomDbEngineVersion].
 */
public suspend fun customDbEngineVersion(
    name: String,
    block: suspend CustomDbEngineVersionResourceBuilder.() -> Unit,
): CustomDbEngineVersion {
    val builder = CustomDbEngineVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomDbEngineVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customDbEngineVersion(name: String): CustomDbEngineVersion {
    val builder = CustomDbEngineVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
