@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.CustomDbEngineVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an custom engine version (CEV) resource for Amazon RDS Custom. For additional information, see [Working with CEVs for RDS Custom for Oracle](https://docs&#46;aws&#46;amazon&#46;com/AmazonRDS/latest/UserGuide/custom-cev&#46;html) and [Working with CEVs for RDS Custom for SQL Server](https://docs&#46;aws&#46;amazon&#46;com/AmazonRDS/latest/UserGuide/custom-cev-sqlserver&#46;html) in the the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html).
 * ## Example Usage
 * ### RDS Custom for Oracle Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.CustomDbEngineVersion;
 * import com.pulumi.aws.rds.CustomDbEngineVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("KMS symmetric key for RDS Custom for Oracle")
 *             .build());
 *         var exampleCustomDbEngineVersion = new CustomDbEngineVersion("exampleCustomDbEngineVersion", CustomDbEngineVersionArgs.builder()
 *             .databaseInstallationFilesS3BucketName("DOC-EXAMPLE-BUCKET")
 *             .databaseInstallationFilesS3Prefix("1915_GI/")
 *             .engine("custom-oracle-ee-cdb")
 *             .engineVersion("19.cdb_cev1")
 *             .kmsKeyId(exampleKey.arn())
 *             .manifest("""
 *   {
 * 	"databaseInstallationFileNames":["V982063-01.zip"]
 *   }
 *             """)
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### RDS Custom for Oracle External Manifest Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.CustomDbEngineVersion;
 * import com.pulumi.aws.rds.CustomDbEngineVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("KMS symmetric key for RDS Custom for Oracle")
 *             .build());
 *         var exampleCustomDbEngineVersion = new CustomDbEngineVersion("exampleCustomDbEngineVersion", CustomDbEngineVersionArgs.builder()
 *             .databaseInstallationFilesS3BucketName("DOC-EXAMPLE-BUCKET")
 *             .databaseInstallationFilesS3Prefix("1915_GI/")
 *             .engine("custom-oracle-ee-cdb")
 *             .engineVersion("19.cdb_cev1")
 *             .kmsKeyId(exampleKey.arn())
 *             .filename("manifest_1915_GI.json")
 *             .manifestHash(computeFileBase64Sha256(manifest_1915_GI.json()))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### RDS Custom for SQL Server Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.CustomDbEngineVersion;
 * import com.pulumi.aws.rds.CustomDbEngineVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new CustomDbEngineVersion("test", CustomDbEngineVersionArgs.builder()
 *             .engine("custom-sqlserver-se")
 *             .engineVersion("15.00.4249.2.cev-1")
 *             .sourceImageId("ami-0aa12345678a12ab1")
 *             .build());
 *     }
 * }
 * ```
 * ### RDS Custom for SQL Server Usage with AMI from another region
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiCopy;
 * import com.pulumi.aws.ec2.AmiCopyArgs;
 * import com.pulumi.aws.rds.CustomDbEngineVersion;
 * import com.pulumi.aws.rds.CustomDbEngineVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiCopy("example", AmiCopyArgs.builder()
 *             .description("A copy of ami-xxxxxxxx")
 *             .sourceAmiId("ami-xxxxxxxx")
 *             .sourceAmiRegion("us-east-1")
 *             .build());
 *         var test = new CustomDbEngineVersion("test", CustomDbEngineVersionArgs.builder()
 *             .engine("custom-sqlserver-se")
 *             .engineVersion("15.00.4249.2.cev-1")
 *             .sourceImageId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import custom engine versions for Amazon RDS custom using the `engine` and `engine_version` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:rds/customDbEngineVersion:CustomDbEngineVersion example custom-oracle-ee-cdb:19.cdb_cev1
 * ```
 * @property databaseInstallationFilesS3BucketName The name of the Amazon S3 bucket that contains the database installation files.
 * @property databaseInstallationFilesS3Prefix The prefix for the Amazon S3 bucket that contains the database installation files.
 * @property description The description of the CEV.
 * @property engine The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
 * @property engineVersion The version of the database engine.
 * @property filename The name of the manifest file within the local filesystem. Conflicts with `manifest`.
 * @property kmsKeyId The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
 * @property manifest The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
 * @property manifestHash Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
 * @property sourceImageId The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
 * @property status The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
 * @property tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CustomDbEngineVersionArgs(
    public val databaseInstallationFilesS3BucketName: Output<String>? = null,
    public val databaseInstallationFilesS3Prefix: Output<String>? = null,
    public val description: Output<String>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val filename: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val manifest: Output<String>? = null,
    public val manifestHash: Output<String>? = null,
    public val sourceImageId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.CustomDbEngineVersionArgs> {
    override fun toJava(): com.pulumi.aws.rds.CustomDbEngineVersionArgs =
        com.pulumi.aws.rds.CustomDbEngineVersionArgs.builder()
            .databaseInstallationFilesS3BucketName(
                databaseInstallationFilesS3BucketName?.applyValue({ args0 ->
                    args0
                }),
            )
            .databaseInstallationFilesS3Prefix(
                databaseInstallationFilesS3Prefix?.applyValue({ args0 ->
                    args0
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .filename(filename?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .manifest(manifest?.applyValue({ args0 -> args0 }))
            .manifestHash(manifestHash?.applyValue({ args0 -> args0 }))
            .sourceImageId(sourceImageId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CustomDbEngineVersionArgs].
 */
@PulumiTagMarker
public class CustomDbEngineVersionArgsBuilder internal constructor() {
    private var databaseInstallationFilesS3BucketName: Output<String>? = null

    private var databaseInstallationFilesS3Prefix: Output<String>? = null

    private var description: Output<String>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var filename: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var manifest: Output<String>? = null

    private var manifestHash: Output<String>? = null

    private var sourceImageId: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Amazon S3 bucket that contains the database installation files.
     */
    @JvmName("onfrulathwhwfmvy")
    public suspend fun databaseInstallationFilesS3BucketName(`value`: Output<String>) {
        this.databaseInstallationFilesS3BucketName = value
    }

    /**
     * @param value The prefix for the Amazon S3 bucket that contains the database installation files.
     */
    @JvmName("somiqlxitkbfvaed")
    public suspend fun databaseInstallationFilesS3Prefix(`value`: Output<String>) {
        this.databaseInstallationFilesS3Prefix = value
    }

    /**
     * @param value The description of the CEV.
     */
    @JvmName("ageukopvvayjdoik")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
     */
    @JvmName("ibcftagwkmbwkwxb")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The version of the database engine.
     */
    @JvmName("kercijlkhpjshuwl")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The name of the manifest file within the local filesystem. Conflicts with `manifest`.
     */
    @JvmName("jkfdbyfkjshkqijj")
    public suspend fun filename(`value`: Output<String>) {
        this.filename = value
    }

    /**
     * @param value The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
     */
    @JvmName("dnirlnudbivvtacx")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
     */
    @JvmName("vlftvktjenkvisqm")
    public suspend fun manifest(`value`: Output<String>) {
        this.manifest = value
    }

    /**
     * @param value Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
     */
    @JvmName("limhwkiwkpcdlyue")
    public suspend fun manifestHash(`value`: Output<String>) {
        this.manifestHash = value
    }

    /**
     * @param value The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
     */
    @JvmName("whreernecbkdrnvl")
    public suspend fun sourceImageId(`value`: Output<String>) {
        this.sourceImageId = value
    }

    /**
     * @param value The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
     */
    @JvmName("rpdmdohpxclnagya")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mytmnwibnwpkcdwj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Amazon S3 bucket that contains the database installation files.
     */
    @JvmName("rrbtxjeffelluexf")
    public suspend fun databaseInstallationFilesS3BucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseInstallationFilesS3BucketName = mapped
    }

    /**
     * @param value The prefix for the Amazon S3 bucket that contains the database installation files.
     */
    @JvmName("wgheuadoemdcnufw")
    public suspend fun databaseInstallationFilesS3Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseInstallationFilesS3Prefix = mapped
    }

    /**
     * @param value The description of the CEV.
     */
    @JvmName("iotkuyqtwottnkqk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
     */
    @JvmName("yctplctpvxjbefvc")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The version of the database engine.
     */
    @JvmName("bmpbujnfegxhaflv")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The name of the manifest file within the local filesystem. Conflicts with `manifest`.
     */
    @JvmName("syhysfftuklbjhab")
    public suspend fun filename(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filename = mapped
    }

    /**
     * @param value The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
     */
    @JvmName("qrmxkyewcaporfyl")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
     */
    @JvmName("pjambxkwjxiynhqm")
    public suspend fun manifest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifest = mapped
    }

    /**
     * @param value Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
     */
    @JvmName("nqnanqnbitpmjogo")
    public suspend fun manifestHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestHash = mapped
    }

    /**
     * @param value The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
     */
    @JvmName("tbepokfoprmgoxlf")
    public suspend fun sourceImageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceImageId = mapped
    }

    /**
     * @param value The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
     */
    @JvmName("ycqhqkylqtgkuejl")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gufwujnnirramysb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bmdtigxpmxcbmikd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CustomDbEngineVersionArgs = CustomDbEngineVersionArgs(
        databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName,
        databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix,
        description = description,
        engine = engine,
        engineVersion = engineVersion,
        filename = filename,
        kmsKeyId = kmsKeyId,
        manifest = manifest,
        manifestHash = manifestHash,
        sourceImageId = sourceImageId,
        status = status,
        tags = tags,
    )
}
