@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.ExportTaskTimeouts
import com.pulumi.aws.rds.kotlin.outputs.ExportTaskTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ExportTask].
 */
@PulumiTagMarker
public class ExportTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExportTaskArgs = ExportTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExportTaskArgsBuilder.() -> Unit) {
        val builder = ExportTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ExportTask {
        val builtJavaResource = com.pulumi.aws.rds.ExportTask(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ExportTask(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS RDS (Relational Database) Export Task.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ExportTask;
 * import com.pulumi.aws.rds.ExportTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ExportTask("example", ExportTaskArgs.builder()
 *             .exportTaskIdentifier("example")
 *             .sourceArn(aws_db_snapshot.example().db_snapshot_arn())
 *             .s3BucketName(aws_s3_bucket.example().id())
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .kmsKeyId(aws_kms_key.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Complete Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.rds.Snapshot;
 * import com.pulumi.aws.rds.SnapshotArgs;
 * import com.pulumi.aws.rds.ExportTask;
 * import com.pulumi.aws.rds.ExportTaskArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "export.rds.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions("s3:ListAllMyBuckets")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions(
 *                         "s3:GetBucketLocation",
 *                         "s3:ListBucket")
 *                     .resources(exampleBucketV2.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions(
 *                         "s3:GetObject",
 *                         "s3:PutObject",
 *                         "s3:DeleteObject")
 *                     .resources(exampleBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build())
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(exampleRole.name())
 *             .policyArn(examplePolicy.arn())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .deletionWindowInDays(10)
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .identifier("example")
 *             .allocatedStorage(10)
 *             .dbName("test")
 *             .engine("mysql")
 *             .engineVersion("5.7")
 *             .instanceClass("db.t3.micro")
 *             .username("foo")
 *             .password("foobarbaz")
 *             .parameterGroupName("default.mysql5.7")
 *             .skipFinalSnapshot(true)
 *             .build());
 *         var exampleSnapshot = new Snapshot("exampleSnapshot", SnapshotArgs.builder()
 *             .dbInstanceIdentifier(exampleInstance.identifier())
 *             .dbSnapshotIdentifier("example")
 *             .build());
 *         var exampleExportTask = new ExportTask("exampleExportTask", ExportTaskArgs.builder()
 *             .exportTaskIdentifier("example")
 *             .sourceArn(exampleSnapshot.dbSnapshotArn())
 *             .s3BucketName(exampleBucketV2.id())
 *             .iamRoleArn(exampleRole.arn())
 *             .kmsKeyId(exampleKey.arn())
 *             .exportOnlies("database")
 *             .s3Prefix("my_prefix/example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a RDS (Relational Database) Export Task using the `export_task_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:rds/exportTask:ExportTask example example
 * ```
 * */
 */
public class ExportTask internal constructor(
    override val javaResource: com.pulumi.aws.rds.ExportTask,
) : KotlinCustomResource(javaResource, ExportTaskMapper) {
    /**
     * Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
     */
    public val exportOnlies: Output<List<String>>?
        get() = javaResource.exportOnlies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Unique identifier for the snapshot export task.
     */
    public val exportTaskIdentifier: Output<String>
        get() = javaResource.exportTaskIdentifier().applyValue({ args0 -> args0 })

    /**
     * Reason the export failed, if it failed.
     */
    public val failureCause: Output<String>
        get() = javaResource.failureCause().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role to use for writing to the Amazon S3 bucket.
     */
    public val iamRoleArn: Output<String>
        get() = javaResource.iamRoleArn().applyValue({ args0 -> args0 })

    /**
     * ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Progress of the snapshot export task as a percentage.
     */
    public val percentProgress: Output<Int>
        get() = javaResource.percentProgress().applyValue({ args0 -> args0 })

    /**
     * Name of the Amazon S3 bucket to export the snapshot to.
     */
    public val s3BucketName: Output<String>
        get() = javaResource.s3BucketName().applyValue({ args0 -> args0 })

    /**
     * Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     */
    public val s3Prefix: Output<String>
        get() = javaResource.s3Prefix().applyValue({ args0 -> args0 })

    /**
     * Time that the snapshot was created.
     */
    public val snapshotTime: Output<String>
        get() = javaResource.snapshotTime().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the snapshot to export.
     * The following arguments are optional:
     */
    public val sourceArn: Output<String>
        get() = javaResource.sourceArn().applyValue({ args0 -> args0 })

    /**
     * Type of source for the export.
     */
    public val sourceType: Output<String>
        get() = javaResource.sourceType().applyValue({ args0 -> args0 })

    /**
     * Status of the export task.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Time that the snapshot export task completed.
     */
    public val taskEndTime: Output<String>
        get() = javaResource.taskEndTime().applyValue({ args0 -> args0 })

    /**
     * Time that the snapshot export task started.
     */
    public val taskStartTime: Output<String>
        get() = javaResource.taskStartTime().applyValue({ args0 -> args0 })

    public val timeouts: Output<ExportTaskTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Warning about the snapshot export task, if any.
     */
    public val warningMessage: Output<String>
        get() = javaResource.warningMessage().applyValue({ args0 -> args0 })
}

public object ExportTaskMapper : ResourceMapper<ExportTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ExportTask::class == javaResource::class

    override fun map(javaResource: Resource): ExportTask = ExportTask(
        javaResource as
            com.pulumi.aws.rds.ExportTask,
    )
}

/**
 * @see [ExportTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExportTask].
 */
public suspend fun exportTask(name: String, block: suspend ExportTaskResourceBuilder.() -> Unit):
    ExportTask {
    val builder = ExportTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExportTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun exportTask(name: String): ExportTask {
    val builder = ExportTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
