@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ExportTaskArgs.builder
import com.pulumi.aws.rds.kotlin.inputs.ExportTaskTimeoutsArgs
import com.pulumi.aws.rds.kotlin.inputs.ExportTaskTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS RDS (Relational Database) Export Task.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ExportTask;
 * import com.pulumi.aws.rds.ExportTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ExportTask("example", ExportTaskArgs.builder()
 *             .exportTaskIdentifier("example")
 *             .sourceArn(aws_db_snapshot.example().db_snapshot_arn())
 *             .s3BucketName(aws_s3_bucket.example().id())
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .kmsKeyId(aws_kms_key.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Complete Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.rds.Snapshot;
 * import com.pulumi.aws.rds.SnapshotArgs;
 * import com.pulumi.aws.rds.ExportTask;
 * import com.pulumi.aws.rds.ExportTaskArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "export.rds.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions("s3:ListAllMyBuckets")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions(
 *                         "s3:GetBucketLocation",
 *                         "s3:ListBucket")
 *                     .resources(exampleBucketV2.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions(
 *                         "s3:GetObject",
 *                         "s3:PutObject",
 *                         "s3:DeleteObject")
 *                     .resources(exampleBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build())
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(exampleRole.name())
 *             .policyArn(examplePolicy.arn())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .deletionWindowInDays(10)
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .identifier("example")
 *             .allocatedStorage(10)
 *             .dbName("test")
 *             .engine("mysql")
 *             .engineVersion("5.7")
 *             .instanceClass("db.t3.micro")
 *             .username("foo")
 *             .password("foobarbaz")
 *             .parameterGroupName("default.mysql5.7")
 *             .skipFinalSnapshot(true)
 *             .build());
 *         var exampleSnapshot = new Snapshot("exampleSnapshot", SnapshotArgs.builder()
 *             .dbInstanceIdentifier(exampleInstance.identifier())
 *             .dbSnapshotIdentifier("example")
 *             .build());
 *         var exampleExportTask = new ExportTask("exampleExportTask", ExportTaskArgs.builder()
 *             .exportTaskIdentifier("example")
 *             .sourceArn(exampleSnapshot.dbSnapshotArn())
 *             .s3BucketName(exampleBucketV2.id())
 *             .iamRoleArn(exampleRole.arn())
 *             .kmsKeyId(exampleKey.arn())
 *             .exportOnlies("database")
 *             .s3Prefix("my_prefix/example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a RDS (Relational Database) Export Task using the `export_task_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:rds/exportTask:ExportTask example example
 * ```
 * @property exportOnlies Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
 * @property exportTaskIdentifier Unique identifier for the snapshot export task.
 * @property iamRoleArn ARN of the IAM role to use for writing to the Amazon S3 bucket.
 * @property kmsKeyId ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
 * @property s3BucketName Name of the Amazon S3 bucket to export the snapshot to.
 * @property s3Prefix Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
 * @property sourceArn Amazon Resource Name (ARN) of the snapshot to export.
 * The following arguments are optional:
 * @property timeouts
 * */
 */
public data class ExportTaskArgs(
    public val exportOnlies: Output<List<String>>? = null,
    public val exportTaskIdentifier: Output<String>? = null,
    public val iamRoleArn: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val s3BucketName: Output<String>? = null,
    public val s3Prefix: Output<String>? = null,
    public val sourceArn: Output<String>? = null,
    public val timeouts: Output<ExportTaskTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ExportTaskArgs> {
    override fun toJava(): com.pulumi.aws.rds.ExportTaskArgs =
        com.pulumi.aws.rds.ExportTaskArgs.builder()
            .exportOnlies(exportOnlies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exportTaskIdentifier(exportTaskIdentifier?.applyValue({ args0 -> args0 }))
            .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .s3BucketName(s3BucketName?.applyValue({ args0 -> args0 }))
            .s3Prefix(s3Prefix?.applyValue({ args0 -> args0 }))
            .sourceArn(sourceArn?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ExportTaskArgs].
 */
@PulumiTagMarker
public class ExportTaskArgsBuilder internal constructor() {
    private var exportOnlies: Output<List<String>>? = null

    private var exportTaskIdentifier: Output<String>? = null

    private var iamRoleArn: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var s3BucketName: Output<String>? = null

    private var s3Prefix: Output<String>? = null

    private var sourceArn: Output<String>? = null

    private var timeouts: Output<ExportTaskTimeoutsArgs>? = null

    /**
     * @param value Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
     */
    @JvmName("hknygehimkgrrvhm")
    public suspend fun exportOnlies(`value`: Output<List<String>>) {
        this.exportOnlies = value
    }

    @JvmName("pkkpfvlgutxegdal")
    public suspend fun exportOnlies(vararg values: Output<String>) {
        this.exportOnlies = Output.all(values.asList())
    }

    /**
     * @param values Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
     */
    @JvmName("dghrptjwhpkjqhbi")
    public suspend fun exportOnlies(values: List<Output<String>>) {
        this.exportOnlies = Output.all(values)
    }

    /**
     * @param value Unique identifier for the snapshot export task.
     */
    @JvmName("pyboyjspioqmqrgf")
    public suspend fun exportTaskIdentifier(`value`: Output<String>) {
        this.exportTaskIdentifier = value
    }

    /**
     * @param value ARN of the IAM role to use for writing to the Amazon S3 bucket.
     */
    @JvmName("bsnxhmxovowiktge")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
     */
    @JvmName("lbcegjlhmnetwwps")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Name of the Amazon S3 bucket to export the snapshot to.
     */
    @JvmName("ovcmuwepbowyeoql")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     */
    @JvmName("eilyrdyiosyvckyp")
    public suspend fun s3Prefix(`value`: Output<String>) {
        this.s3Prefix = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the snapshot to export.
     * The following arguments are optional:
     */
    @JvmName("vkpdjxsrsixudlnr")
    public suspend fun sourceArn(`value`: Output<String>) {
        this.sourceArn = value
    }

    /**
     * @param value
     */
    @JvmName("fsjqtbmyhkaqhges")
    public suspend fun timeouts(`value`: Output<ExportTaskTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
     */
    @JvmName("sjmwwfmkqsqpxflb")
    public suspend fun exportOnlies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportOnlies = mapped
    }

    /**
     * @param values Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
     */
    @JvmName("sloapynqpwytvvuj")
    public suspend fun exportOnlies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exportOnlies = mapped
    }

    /**
     * @param value Unique identifier for the snapshot export task.
     */
    @JvmName("fcfqontodmwqcxjp")
    public suspend fun exportTaskIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportTaskIdentifier = mapped
    }

    /**
     * @param value ARN of the IAM role to use for writing to the Amazon S3 bucket.
     */
    @JvmName("nhogojarjwjekpnr")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
     */
    @JvmName("dgsvbukkkblmmvie")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Name of the Amazon S3 bucket to export the snapshot to.
     */
    @JvmName("yrtmqkelqjfternd")
    public suspend fun s3BucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     */
    @JvmName("potnnpksfmnesgvf")
    public suspend fun s3Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Prefix = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the snapshot to export.
     * The following arguments are optional:
     */
    @JvmName("ijjwqofflbguxdhy")
    public suspend fun sourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("jnhrwxgxunkubmiu")
    public suspend fun timeouts(`value`: ExportTaskTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("umucbwxrjnrlaabl")
    public suspend fun timeouts(argument: suspend ExportTaskTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ExportTaskTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ExportTaskArgs = ExportTaskArgs(
        exportOnlies = exportOnlies,
        exportTaskIdentifier = exportTaskIdentifier,
        iamRoleArn = iamRoleArn,
        kmsKeyId = kmsKeyId,
        s3BucketName = s3BucketName,
        s3Prefix = s3Prefix,
        sourceArn = sourceArn,
        timeouts = timeouts,
    )
}
