@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.GlobalClusterGlobalClusterMember
import com.pulumi.aws.rds.kotlin.outputs.GlobalClusterGlobalClusterMember.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GlobalCluster].
 */
@PulumiTagMarker
public class GlobalClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalClusterArgs = GlobalClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalClusterArgsBuilder.() -> Unit) {
        val builder = GlobalClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GlobalCluster {
        val builtJavaResource = com.pulumi.aws.rds.GlobalCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GlobalCluster(builtJavaResource)
    }
}

/**
 * Manages an RDS Global Cluster, which is an Aurora global database spread across multiple regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
 * More information about Aurora global databases can be found in the [Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database-creating).
 * ## Example Usage
 * ### New MySQL Global Cluster
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.GlobalCluster;
 * import com.pulumi.aws.rds.GlobalClusterArgs;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GlobalCluster("example", GlobalClusterArgs.builder()
 *             .globalClusterIdentifier("global-test")
 *             .engine("aurora")
 *             .engineVersion("5.6.mysql_aurora.1.22.2")
 *             .databaseName("example_db")
 *             .build());
 *         var primaryCluster = new Cluster("primaryCluster", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-primary-cluster")
 *             .masterUsername("username")
 *             .masterPassword("somepass123")
 *             .databaseName("example_db")
 *             .globalClusterIdentifier(example.id())
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.primary())
 *                 .build());
 *         var primaryClusterInstance = new ClusterInstance("primaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .identifier("test-primary-cluster-instance")
 *             .clusterIdentifier(primaryCluster.id())
 *             .instanceClass("db.r4.large")
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.primary())
 *                 .build());
 *         var secondaryCluster = new Cluster("secondaryCluster", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-secondary-cluster")
 *             .globalClusterIdentifier(example.id())
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.secondary())
 *                 .dependsOn(primaryClusterInstance)
 *                 .build());
 *         var secondaryClusterInstance = new ClusterInstance("secondaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .identifier("test-secondary-cluster-instance")
 *             .clusterIdentifier(secondaryCluster.id())
 *             .instanceClass("db.r4.large")
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.secondary())
 *                 .build());
 *     }
 * }
 * ```
 * ### New PostgreSQL Global Cluster
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.rds.GlobalCluster;
 * import com.pulumi.aws.rds.GlobalClusterArgs;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Provider("primary", ProviderArgs.builder()
 *             .region("us-east-2")
 *             .build());
 *         var secondary = new Provider("secondary", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var example = new GlobalCluster("example", GlobalClusterArgs.builder()
 *             .globalClusterIdentifier("global-test")
 *             .engine("aurora-postgresql")
 *             .engineVersion("11.9")
 *             .databaseName("example_db")
 *             .build());
 *         var primaryCluster = new Cluster("primaryCluster", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-primary-cluster")
 *             .masterUsername("username")
 *             .masterPassword("somepass123")
 *             .databaseName("example_db")
 *             .globalClusterIdentifier(example.id())
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.primary())
 *                 .build());
 *         var primaryClusterInstance = new ClusterInstance("primaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .identifier("test-primary-cluster-instance")
 *             .clusterIdentifier(primaryCluster.id())
 *             .instanceClass("db.r4.large")
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.primary())
 *                 .build());
 *         var secondaryCluster = new Cluster("secondaryCluster", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-secondary-cluster")
 *             .globalClusterIdentifier(example.id())
 *             .skipFinalSnapshot(true)
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.secondary())
 *                 .dependsOn(primaryClusterInstance)
 *                 .build());
 *         var secondaryClusterInstance = new ClusterInstance("secondaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .identifier("test-secondary-cluster-instance")
 *             .clusterIdentifier(secondaryCluster.id())
 *             .instanceClass("db.r4.large")
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.secondary())
 *                 .build());
 *     }
 * }
 * ```
 * ### New Global Cluster From Existing DB Cluster
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.GlobalCluster;
 * import com.pulumi.aws.rds.GlobalClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCluster = new Cluster("exampleCluster");
 *         var exampleGlobalCluster = new GlobalCluster("exampleGlobalCluster", GlobalClusterArgs.builder()
 *             .forceDestroy(true)
 *             .globalClusterIdentifier("example")
 *             .sourceDbClusterIdentifier(exampleCluster.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Upgrading Engine Versions
 * When you upgrade the version of an `aws.rds.GlobalCluster`, the provider will attempt to in-place upgrade the engine versions of all associated clusters. Since the `aws.rds.Cluster` resource is being updated through the `aws.rds.GlobalCluster`, you are likely to get an error (`Provider produced inconsistent final plan`). To avoid this, use the `lifecycle` `ignore_changes` meta argument as shown below on the `aws.rds.Cluster`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.GlobalCluster;
 * import com.pulumi.aws.rds.GlobalClusterArgs;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GlobalCluster("example", GlobalClusterArgs.builder()
 *             .globalClusterIdentifier("kyivkharkiv")
 *             .engine("aurora-mysql")
 *             .engineVersion("5.7.mysql_aurora.2.07.5")
 *             .build());
 *         var primaryCluster = new Cluster("primaryCluster", ClusterArgs.builder()
 *             .allowMajorVersionUpgrade(true)
 *             .applyImmediately(true)
 *             .clusterIdentifier("odessadnipro")
 *             .databaseName("totoro")
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .globalClusterIdentifier(example.id())
 *             .masterPassword("satsukimae")
 *             .masterUsername("maesatsuki")
 *             .skipFinalSnapshot(true)
 *             .build());
 *         var primaryClusterInstance = new ClusterInstance("primaryClusterInstance", ClusterInstanceArgs.builder()
 *             .applyImmediately(true)
 *             .clusterIdentifier(primaryCluster.id())
 *             .engine(primaryCluster.engine())
 *             .engineVersion(primaryCluster.engineVersion())
 *             .identifier("donetsklviv")
 *             .instanceClass("db.r4.large")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_rds_global_cluster` using the RDS Global Cluster identifier. For example:
 * ```sh
 *  $ pulumi import aws:rds/globalCluster:GlobalCluster example example
 * ```
 *  Certain resource arguments, like `force_destroy`, only exist within this provider. If the argument is set in the the provider configuration on an imported resource, This provider will show a difference on the first plan after import to update the state value. This change is safe to apply immediately so the state matches the desired configuration.
 * Certain resource arguments, like `source_db_cluster_identifier`, do not have an API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 */
public class GlobalCluster internal constructor(
    override val javaResource: com.pulumi.aws.rds.GlobalCluster,
) : KotlinCustomResource(javaResource, GlobalClusterMapper) {
    /**
     * RDS Global Cluster Amazon Resource Name (ARN)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name for an automatically created database on cluster creation.
     */
    public val databaseName: Output<String>?
        get() = javaResource.databaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Valid values: `aurora`, `aurora-mysql`, `aurora-postgresql`. Defaults to `aurora`. Conflicts with `source_db_cluster_identifier`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * Engine version of the Aurora global database. The `engine`, `engine_version`, and `instance_class` (on the `aws.rds.ClusterInstance`) must together support global databases. See [Using Amazon Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) for more information. By upgrading the engine version, the provider will upgrade cluster members. **NOTE:** To avoid an `inconsistent final plan` error while upgrading, use the `lifecycle` `ignore_changes` for `engine_version` meta argument on the associated `aws.rds.Cluster` resource as shown above in Upgrading Engine Versions example.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    public val engineVersionActual: Output<String>
        get() = javaResource.engineVersionActual().applyValue({ args0 -> args0 })

    /**
     * Enable to remove DB Cluster members from Global Cluster on destroy. Required with `source_db_cluster_identifier`.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Global cluster identifier.
     */
    public val globalClusterIdentifier: Output<String>
        get() = javaResource.globalClusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * Set of objects containing Global Cluster members.
     */
    public val globalClusterMembers: Output<List<GlobalClusterGlobalClusterMember>>
        get() = javaResource.globalClusterMembers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * AWS Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed
     */
    public val globalClusterResourceId: Output<String>
        get() = javaResource.globalClusterResourceId().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
     */
    public val sourceDbClusterIdentifier: Output<String>
        get() = javaResource.sourceDbClusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
     */
    public val storageEncrypted: Output<Boolean>
        get() = javaResource.storageEncrypted().applyValue({ args0 -> args0 })
}

public object GlobalClusterMapper : ResourceMapper<GlobalCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.GlobalCluster::class == javaResource::class

    override fun map(javaResource: Resource): GlobalCluster = GlobalCluster(
        javaResource as
            com.pulumi.aws.rds.GlobalCluster,
    )
}

/**
 * @see [GlobalCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalCluster].
 */
public suspend fun globalCluster(
    name: String,
    block: suspend GlobalClusterResourceBuilder.() -> Unit,
): GlobalCluster {
    val builder = GlobalClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalCluster(name: String): GlobalCluster {
    val builder = GlobalClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
