@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.InstanceBlueGreenUpdate
import com.pulumi.aws.rds.kotlin.outputs.InstanceListenerEndpoint
import com.pulumi.aws.rds.kotlin.outputs.InstanceMasterUserSecret
import com.pulumi.aws.rds.kotlin.outputs.InstanceRestoreToPointInTime
import com.pulumi.aws.rds.kotlin.outputs.InstanceS3Import
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.rds.kotlin.outputs.InstanceBlueGreenUpdate.Companion.toKotlin as instanceBlueGreenUpdateToKotlin
import com.pulumi.aws.rds.kotlin.outputs.InstanceListenerEndpoint.Companion.toKotlin as instanceListenerEndpointToKotlin
import com.pulumi.aws.rds.kotlin.outputs.InstanceMasterUserSecret.Companion.toKotlin as instanceMasterUserSecretToKotlin
import com.pulumi.aws.rds.kotlin.outputs.InstanceRestoreToPointInTime.Companion.toKotlin as instanceRestoreToPointInTimeToKotlin
import com.pulumi.aws.rds.kotlin.outputs.InstanceS3Import.Companion.toKotlin as instanceS3ImportToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.aws.rds.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides an RDS instance resource.  A DB instance is an isolated database
 * environment in the cloud.  A DB instance can contain multiple user-created
 * databases.
 * Changes to a DB instance can occur when you manually change a parameter, such as
 * `allocated_storage`, and are reflected in the next maintenance window. Because
 * of this, this provider may report a difference in its planning phase because a
 * modification has not yet taken place. You can use the `apply_immediately` flag
 * to instruct the service to apply the change immediately (see documentation
 * below).
 * When upgrading the major version of an engine, `allow_major_version_upgrade` must be set to `true`.
 * > **Note:** using `apply_immediately` can result in a brief downtime as the server reboots.
 * See the AWS Docs on [RDS Instance Maintenance][instance-maintenance] for more information.
 * > **Note:** All arguments including the username and password will be stored in the raw state as plain-text.
 * Read more about sensitive data instate.
 * ## RDS Instance Class Types
 * Amazon RDS supports three types of instance classes: Standard, Memory Optimized, and Burstable Performance.
 * For more information please read the AWS RDS documentation about [DB Instance Class Types](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
 * ## Low-Downtime Updates
 * By default, RDS applies updates to DB Instances in-place, which can lead to service interruptions.
 * Low-downtime updates minimize service interruptions by performing the updates with an [RDS Blue/Green deployment][blue-green] and switching over the instances when complete.
 * Low-downtime updates are only available for DB Instances using MySQL and MariaDB,
 * as other engines are not supported by RDS Blue/Green deployments.
 * Backups must be enabled to use low-downtime updates.
 * Enable low-downtime updates by setting `blue_green_update.enabled` to `true`.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .dbName("mydb")
 *             .engine("mysql")
 *             .engineVersion("5.7")
 *             .instanceClass("db.t3.micro")
 *             .parameterGroupName("default.mysql5.7")
 *             .password("foobarbaz")
 *             .skipFinalSnapshot(true)
 *             .username("foo")
 *             .build());
 *     }
 * }
 * ```
 * ### RDS Custom for Oracle Usage with Replica
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.RdsFunctions;
 * import com.pulumi.aws.rds.inputs.GetOrderableDbInstanceArgs;
 * import com.pulumi.aws.kms.KmsFunctions;
 * import com.pulumi.aws.kms.inputs.GetKeyArgs;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var custom-oracle = RdsFunctions.getOrderableDbInstance(GetOrderableDbInstanceArgs.builder()
 *             .engine("custom-oracle-ee")
 *             .engineVersion("19.c.ee.002")
 *             .licenseModel("bring-your-own-license")
 *             .storageType("gp3")
 *             .preferredInstanceClasses(
 *                 "db.r5.xlarge",
 *                 "db.r5.2xlarge",
 *                 "db.r5.4xlarge")
 *             .build());
 *         final var byId = KmsFunctions.getKey(GetKeyArgs.builder()
 *             .keyId("example-ef278353ceba4a5a97de6784565b9f78")
 *             .build());
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .allocatedStorage(50)
 *             .autoMinorVersionUpgrade(false)
 *             .customIamInstanceProfile("AWSRDSCustomInstanceProfile")
 *             .backupRetentionPeriod(7)
 *             .dbSubnetGroupName(local.db_subnet_group_name())
 *             .engine(custom_oracle.engine())
 *             .engineVersion(custom_oracle.engineVersion())
 *             .identifier("ee-instance-demo")
 *             .instanceClass(custom_oracle.instanceClass())
 *             .kmsKeyId(byId.applyValue(getKeyResult -> getKeyResult.arn()))
 *             .licenseModel(custom_oracle.licenseModel())
 *             .multiAz(false)
 *             .password("avoid-plaintext-passwords")
 *             .username("test")
 *             .storageEncrypted(true)
 *             .timeouts(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *         var test_replica = new Instance("test-replica", InstanceArgs.builder()
 *             .replicateSourceDb(default_.identifier())
 *             .replicaMode("mounted")
 *             .autoMinorVersionUpgrade(false)
 *             .customIamInstanceProfile("AWSRDSCustomInstanceProfile")
 *             .backupRetentionPeriod(7)
 *             .identifier("ee-instance-replica")
 *             .instanceClass(custom_oracle.instanceClass())
 *             .kmsKeyId(byId.applyValue(getKeyResult -> getKeyResult.arn()))
 *             .multiAz(false)
 *             .skipFinalSnapshot(true)
 *             .storageEncrypted(true)
 *             .timeouts(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ### RDS Custom for SQL Server
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.RdsFunctions;
 * import com.pulumi.aws.rds.inputs.GetOrderableDbInstanceArgs;
 * import com.pulumi.aws.kms.KmsFunctions;
 * import com.pulumi.aws.kms.inputs.GetKeyArgs;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var custom-sqlserver = RdsFunctions.getOrderableDbInstance(GetOrderableDbInstanceArgs.builder()
 *             .engine("custom-sqlserver-se")
 *             .engineVersion("15.00.4249.2.v1")
 *             .storageType("gp3")
 *             .preferredInstanceClasses(
 *                 "db.r5.xlarge",
 *                 "db.r5.2xlarge",
 *                 "db.r5.4xlarge")
 *             .build());
 *         final var byId = KmsFunctions.getKey(GetKeyArgs.builder()
 *             .keyId("example-ef278353ceba4a5a97de6784565b9f78")
 *             .build());
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .allocatedStorage(500)
 *             .autoMinorVersionUpgrade(false)
 *             .customIamInstanceProfile("AWSRDSCustomSQLServerInstanceRole")
 *             .backupRetentionPeriod(7)
 *             .dbSubnetGroupName(local.db_subnet_group_name())
 *             .engine(custom_sqlserver.engine())
 *             .engineVersion(custom_sqlserver.engineVersion())
 *             .identifier("sql-instance-demo")
 *             .instanceClass(custom_sqlserver.instanceClass())
 *             .kmsKeyId(byId.applyValue(getKeyResult -> getKeyResult.arn()))
 *             .multiAz(false)
 *             .password("avoid-plaintext-passwords")
 *             .storageEncrypted(true)
 *             .username("test")
 *             .timeouts(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ### Storage Autoscaling
 * To enable Storage Autoscaling with instances that support the feature, define the `max_allocated_storage` argument higher than the `allocated_storage` argument. This provider will automatically hide differences with the `allocated_storage` argument value if autoscaling occurs.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .allocatedStorage(50)
 *             .maxAllocatedStorage(100)
 *             .build());
 *     }
 * }
 * ```
 * ### Managed Master Passwords via Secrets Manager, default KMS Key
 * > More information about RDS/Aurora Aurora integrates with Secrets Manager to manage master user passwords for your DB clusters can be found in the [RDS User Guide](https://aws.amazon.com/about-aws/whats-new/2022/12/amazon-rds-integration-aws-secrets-manager/) and [Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html).
 * You can specify the `manage_master_user_password` attribute to enable managing the master password with Secrets Manager. You can also update an existing cluster to use Secrets Manager by specify the `manage_master_user_password` attribute and removing the `password` attribute (removal is required).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .dbName("mydb")
 *             .engine("mysql")
 *             .engineVersion("5.7")
 *             .instanceClass("db.t3.micro")
 *             .manageMasterUserPassword(true)
 *             .parameterGroupName("default.mysql5.7")
 *             .username("foo")
 *             .build());
 *     }
 * }
 * ```
 * ### Managed Master Passwords via Secrets Manager, specific KMS Key
 * > More information about RDS/Aurora Aurora integrates with Secrets Manager to manage master user passwords for your DB clusters can be found in the [RDS User Guide](https://aws.amazon.com/about-aws/whats-new/2022/12/amazon-rds-integration-aws-secrets-manager/) and [Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html).
 * You can specify the `master_user_secret_kms_key_id` attribute to specify a specific KMS Key.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("Example KMS Key")
 *             .build());
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .dbName("mydb")
 *             .engine("mysql")
 *             .engineVersion("5.7")
 *             .instanceClass("db.t3.micro")
 *             .manageMasterUserPassword(true)
 *             .masterUserSecretKmsKeyId(example.keyId())
 *             .username("foo")
 *             .parameterGroupName("default.mysql5.7")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DB Instances using the `identifier`. For example:
 * ```sh
 *  $ pulumi import aws:rds/instance:Instance default mydb-rds-instance
 * ```
 *
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.aws.rds.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Specifies the DNS address of the DB instance.
     */
    public val address: Output<String>
        get() = javaResource.address().applyValue({ args0 -> args0 })

    /**
     * The allocated storage in gibibytes. If `max_allocated_storage` is configured, this argument represents the initial storage allocation and differences from the configuration will be ignored automatically when Storage Autoscaling occurs. If `replicate_source_db` is set, the value is ignored during the creation of the instance.
     */
    public val allocatedStorage: Output<Int>
        get() = javaResource.allocatedStorage().applyValue({ args0 -> args0 })

    /**
     * Indicates that major version
     * upgrades are allowed. Changing this parameter does not result in an outage and
     * the change is asynchronously applied as soon as possible.
     */
    public val allowMajorVersionUpgrade: Output<Boolean>?
        get() = javaResource.allowMajorVersionUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether any database modifications
     * are applied immediately, or during the next maintenance window. Default is
     * `false`. See [Amazon RDS Documentation for more
   * information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
     */
    public val applyImmediately: Output<Boolean>?
        get() = javaResource.applyImmediately().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the RDS instance.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Indicates that minor engine upgrades
     * will be applied automatically to the DB instance during the maintenance window.
     * Defaults to true.
     */
    public val autoMinorVersionUpgrade: Output<Boolean>?
        get() = javaResource.autoMinorVersionUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The AZ for the RDS instance.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The days to retain backups for.
     * Must be between `0` and `35`.
     * Default is `0`.
     * Must be greater than `0` if the database is used as a source for a [Read Replica][instance-replication],
     * uses low-downtime updates,
     * or will use [RDS Blue/Green deployments][blue-green].
     */
    public val backupRetentionPeriod: Output<Int>
        get() = javaResource.backupRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * Specifies where automated backups and manual snapshots are stored. Possible values are `region` (default) and `outposts`. See [Working with Amazon RDS on AWS Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) for more information.
     */
    public val backupTarget: Output<String>
        get() = javaResource.backupTarget().applyValue({ args0 -> args0 })

    /**
     * The daily time range (in UTC) during which automated backups are created if they are enabled.
     * Example: "09:46-10:16". Must not overlap with `maintenance_window`.
     */
    public val backupWindow: Output<String>
        get() = javaResource.backupWindow().applyValue({ args0 -> args0 })

    /**
     * Enables low-downtime updates using [RDS Blue/Green deployments][blue-green].
     * See `blue_green_update` below.
     */
    public val blueGreenUpdate: Output<InstanceBlueGreenUpdate>?
        get() = javaResource.blueGreenUpdate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceBlueGreenUpdateToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The identifier of the CA certificate for the DB instance.
     */
    public val caCertIdentifier: Output<String>
        get() = javaResource.caCertIdentifier().applyValue({ args0 -> args0 })

    /**
     * The character set name to use for DB
     * encoding in Oracle and Microsoft SQL instances (collation). This can't be changed. See [Oracle Character Sets
   * Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html)
     * or [Server-Level Collation for Microsoft SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.CommonDBATasks.Collation.html) for more information.
     */
    public val characterSetName: Output<String>
        get() = javaResource.characterSetName().applyValue({ args0 -> args0 })

    /**
     * Copy all Instance `tags` to snapshots. Default is `false`.
     */
    public val copyTagsToSnapshot: Output<Boolean>?
        get() = javaResource.copyTagsToSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
     */
    public val customIamInstanceProfile: Output<String>?
        get() = javaResource.customIamInstanceProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance. See [CoIP for RDS on Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html#rds-on-outposts.coip) for more information.
     * > **NOTE:** Removing the `replicate_source_db` attribute from an existing RDS
     * Replicate database managed by the provider will promote the database to a fully
     * standalone database.
     */
    public val customerOwnedIpEnabled: Output<Boolean>?
        get() = javaResource.customerOwnedIpEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance. Note that this does not apply for Oracle or SQL Server engines. See the [AWS documentation](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/create-db-instance.html) for more details on what applies for those engines. If you are providing an Oracle db name, it needs to be in all upper case. Cannot be specified for a replica.
     */
    public val dbName: Output<String>
        get() = javaResource.dbName().applyValue({ args0 -> args0 })

    /**
     * Name of DB subnet group. DB instance will
     * be created in the VPC associated with the DB subnet group. If unspecified, will
     * be created in the `default` VPC, or in EC2 Classic, if available. When working
     * with read replicas, it should be specified only if the source database
     * specifies an instance in another AWS Region. See [DBSubnetGroupName in API
   * action CreateDBInstanceReadReplica](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstanceReadReplica.html)
     * for additional read replica constraints.
     */
    public val dbSubnetGroupName: Output<String>
        get() = javaResource.dbSubnetGroupName().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to remove automated backups immediately after the DB instance is deleted. Default is `true`.
     */
    public val deleteAutomatedBackups: Output<Boolean>?
        get() = javaResource.deleteAutomatedBackups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If the DB instance should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Directory Service Active Directory domain to create the instance in.
     */
    public val domain: Output<String>?
        get() = javaResource.domain().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the IAM role to be used when making API calls to the Directory Service.
     */
    public val domainIamRoleName: Output<String>?
        get() = javaResource.domainIamRoleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set of log types to enable for exporting to CloudWatch logs. If omitted, no logs will be exported. Valid values (depending on `engine`). MySQL and MariaDB: `audit`, `error`, `general`, `slowquery`. PostgreSQL: `postgresql`, `upgrade`. MSSQL: `agent` , `error`. Oracle: `alert`, `audit`, `listener`, `trace`.
     */
    public val enabledCloudwatchLogsExports: Output<List<String>>?
        get() = javaResource.enabledCloudwatchLogsExports().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The connection endpoint in `address:port` format.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The database engine to use. For supported values, see the Engine parameter in [API action CreateDBInstance](https://docs&#46;aws&#46;amazon&#46;com/AmazonRDS/latest/APIReference/API_CreateDBInstance&#46;html)&#46; Note that for Amazon Aurora instances the engine must match the DB cluster's engine'&#46; For information on the difference between the available Aurora MySQL engines see [Comparison between Aurora MySQL 1 and Aurora MySQL 2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Updates.20180206.html) in the Amazon RDS User Guide.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The engine version to use. If `auto_minor_version_upgrade` is enabled, you can provide a prefix of the version such as `5.7` (for `5.7.10`). The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. For supported values, see the EngineVersion parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine version must match the DB cluster's engine version'.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The running version of the database.
     */
    public val engineVersionActual: Output<String>
        get() = javaResource.engineVersionActual().applyValue({ args0 -> args0 })

    /**
     * The name of your final DB snapshot
     * when this DB instance is deleted. Must be provided if `skip_final_snapshot` is
     * set to `false`. The value must begin with a letter, only contain alphanumeric characters and hyphens, and not end with a hyphen or contain two consecutive hyphens. Must not be provided when deleting a read replica.
     */
    public val finalSnapshotIdentifier: Output<String>?
        get() = javaResource.finalSnapshotIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether mappings of AWS Identity and Access Management (IAM) accounts to database
     * accounts is enabled.
     */
    public val iamDatabaseAuthenticationEnabled: Output<Boolean>?
        get() = javaResource.iamDatabaseAuthenticationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the RDS instance, if omitted, this provider will assign a random, unique identifier. Required if `restore_to_point_in_time` is specified.
     */
    public val identifier: Output<String>
        get() = javaResource.identifier().applyValue({ args0 -> args0 })

    /**
     * Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    public val identifierPrefix: Output<String>
        get() = javaResource.identifierPrefix().applyValue({ args0 -> args0 })

    /**
     * The instance type of the RDS instance.
     */
    public val instanceClass: Output<String>
        get() = javaResource.instanceClass().applyValue({ args0 -> args0 })

    /**
     * The amount of provisioned IOPS. Setting this implies a
     * storage_type of "io1". Can only be set when `storage_type` is `"io1"` or `"gp3"`.
     * Cannot be specified for gp3 storage if the `allocated_storage` value is below a per-`engine` threshold.
     * See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
     */
    public val iops: Output<Int>
        get() = javaResource.iops().applyValue({ args0 -> args0 })

    /**
     * The ARN for the KMS encryption key. If creating an
     * encrypted replica, set this to the destination KMS ARN.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The latest time, in UTC [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), to which a database can be restored with point-in-time restore.
     */
    public val latestRestorableTime: Output<String>
        get() = javaResource.latestRestorableTime().applyValue({ args0 -> args0 })

    /**
     * License model information for this DB instance. Valid values for this field are as follows:
     * * RDS for MariaDB: `general-public-license`
     * * RDS for Microsoft SQL Server: `license-included`
     * * RDS for MySQL: `general-public-license`
     * * RDS for Oracle: `bring-your-own-license | license-included`
     * * RDS for PostgreSQL: `postgresql-license`
     */
    public val licenseModel: Output<String>
        get() = javaResource.licenseModel().applyValue({ args0 -> args0 })

    /**
     * Specifies the listener connection endpoint for SQL Server Always On. See endpoint below.
     */
    public val listenerEndpoints: Output<List<InstanceListenerEndpoint>>
        get() = javaResource.listenerEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceListenerEndpointToKotlin(args0) })
            })
        })

    /**
     * The window to perform maintenance in.
     * Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00". See [RDS
   * Maintenance Window
   * docs](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow)
     * for more information.
     */
    public val maintenanceWindow: Output<String>
        get() = javaResource.maintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `password` is provided.
     */
    public val manageMasterUserPassword: Output<Boolean>?
        get() = javaResource.manageMasterUserPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
     */
    public val masterUserSecretKmsKeyId: Output<String>
        get() = javaResource.masterUserSecretKmsKeyId().applyValue({ args0 -> args0 })

    /**
     * A block that specifies the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
     */
    public val masterUserSecrets: Output<List<InstanceMasterUserSecret>>
        get() = javaResource.masterUserSecrets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceMasterUserSecretToKotlin(args0) })
            })
        })

    /**
     * When configured, the upper limit to which Amazon RDS can automatically scale the storage of the DB instance. Configuring this will automatically ignore differences to `allocated_storage`. Must be greater than or equal to `allocated_storage` or `0` to disable Storage Autoscaling.
     */
    public val maxAllocatedStorage: Output<Int>?
        get() = javaResource.maxAllocatedStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The interval, in seconds, between points
     * when Enhanced Monitoring metrics are collected for the DB instance. To disable
     * collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid
     * Values: 0, 1, 5, 10, 15, 30, 60.
     */
    public val monitoringInterval: Output<Int>?
        get() = javaResource.monitoringInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN for the IAM role that permits RDS
     * to send enhanced monitoring metrics to CloudWatch Logs. You can find more
     * information on the [AWS
   * Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html)
     * what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
     */
    public val monitoringRoleArn: Output<String>
        get() = javaResource.monitoringRoleArn().applyValue({ args0 -> args0 })

    /**
     * Specifies if the RDS instance is multi-AZ
     */
    public val multiAz: Output<Boolean>
        get() = javaResource.multiAz().applyValue({ args0 -> args0 })

    @Deprecated(
        message = """
  This property has been deprecated. Please use 'dbName' instead.
  """,
    )
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The national character set is used in the NCHAR, NVARCHAR2, and NCLOB data types for Oracle instances. This can't be changed. See [Oracle Character Sets
   * Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html).
     */
    public val ncharCharacterSetName: Output<String>
        get() = javaResource.ncharCharacterSetName().applyValue({ args0 -> args0 })

    /**
     * The network type of the DB instance. Valid values: `IPV4`, `DUAL`.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * Name of the DB option group to associate.
     */
    public val optionGroupName: Output<String>
        get() = javaResource.optionGroupName().applyValue({ args0 -> args0 })

    /**
     * Name of the DB parameter group to
     * associate.
     */
    public val parameterGroupName: Output<String>
        get() = javaResource.parameterGroupName().applyValue({ args0 -> args0 })

    /**
     * (Required unless `manage_master_user_password` is set to true or unless a `snapshot_identifier` or `replicate_source_db`
     * is provided or `manage_master_user_password` is set.) Password for the master DB user. Note that this may show up in
     * logs, and it will be stored in the state file. Cannot be set if `manage_master_user_password` is set to `true`.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether Performance Insights are enabled. Defaults to false.
     */
    public val performanceInsightsEnabled: Output<Boolean>?
        get() = javaResource.performanceInsightsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true. Once KMS key is set, it can never be changed.
     */
    public val performanceInsightsKmsKeyId: Output<String>
        get() = javaResource.performanceInsightsKmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
     */
    public val performanceInsightsRetentionPeriod: Output<Int>
        get() = javaResource.performanceInsightsRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * The port on which the DB accepts connections.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * Bool to control if instance is publicly
     * accessible. Default is `false`.
     */
    public val publiclyAccessible: Output<Boolean>?
        get() = javaResource.publiclyAccessible().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the replica is in either `mounted` or `open-read-only` mode. This attribute
     * is only supported by Oracle instances. Oracle replicas operate in `open-read-only` mode unless otherwise specified. See [Working with Oracle Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) for more information.
     */
    public val replicaMode: Output<String>
        get() = javaResource.replicaMode().applyValue({ args0 -> args0 })

    public val replicas: Output<List<String>>
        get() = javaResource.replicas().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Specifies that this resource is a Replicate
     * database, and to use this value as the source database. This correlates to the
     * `identifier` of another Amazon RDS Database to replicate (if replicating within
     * a single region) or ARN of the Amazon RDS Database to replicate (if replicating
     * cross-region). Note that if you are
     * creating a cross-region replica of an encrypted database you will also need to
     * specify a `kms_key_id`. See [DB Instance Replication][instance-replication] and [Working with
   * PostgreSQL and MySQL Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html)
     * for more information on using Replication.
     */
    public val replicateSourceDb: Output<String>?
        get() = javaResource.replicateSourceDb().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The RDS Resource ID of this instance.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * A configuration block for restoring a DB instance to an arbitrary point in time. Requires the `identifier` argument to be set with the name of the new DB instance to be created. See Restore To Point In Time below for details.
     */
    public val restoreToPointInTime: Output<InstanceRestoreToPointInTime>?
        get() = javaResource.restoreToPointInTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceRestoreToPointInTimeToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Restore from a Percona Xtrabackup in S3.  See [Importing Data into an Amazon RDS MySQL DB Instance](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html)
     */
    public val s3Import: Output<InstanceS3Import>?
        get() = javaResource.s3Import().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instanceS3ImportToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Determines whether a final DB snapshot is
     * created before the DB instance is deleted. If true is specified, no DBSnapshot
     * is created. If false is specified, a DB snapshot is created before the DB
     * instance is deleted, using the value from `final_snapshot_identifier`. Default
     * is `false`.
     */
    public val skipFinalSnapshot: Output<Boolean>?
        get() = javaResource.skipFinalSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether or not to create this
     * database from a snapshot. This correlates to the snapshot ID you'd find in the
     * RDS console, e.g: rds:production-2015-06-26-06-05.
     */
    public val snapshotIdentifier: Output<String>
        get() = javaResource.snapshotIdentifier().applyValue({ args0 -> args0 })

    /**
     * The RDS instance status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the DB instance is
     * encrypted. Note that if you are creating a cross-region read replica this field
     * is ignored and you should instead declare `kms_key_id` with a valid ARN. The
     * default is `false` if not specified.
     */
    public val storageEncrypted: Output<Boolean>?
        get() = javaResource.storageEncrypted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage throughput value for the DB instance. Can only be set when `storage_type` is `"gp3"`. Cannot be specified if the `allocated_storage` value is below a per-`engine` threshold. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
     */
    public val storageThroughput: Output<Int>
        get() = javaResource.storageThroughput().applyValue({ args0 -> args0 })

    /**
     * One of "standard" (magnetic), "gp2" (general
     * purpose SSD), "gp3" (general purpose SSD that needs `iops` independently)
     * or "io1" (provisioned IOPS SSD). The default is "io1" if `iops` is specified,
     * "gp2" if not.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Time zone of the DB instance. `timezone` is currently
     * only supported by Microsoft SQL Server. The `timezone` can only be set on
     * creation. See [MSSQL User
   * Guide](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone)
     * for more information.
     */
    public val timezone: Output<String>
        get() = javaResource.timezone().applyValue({ args0 -> args0 })

    /**
     * (Required unless a `snapshot_identifier` or `replicate_source_db`
     * is provided) Username for the master DB user. Cannot be specified for a replica.
     */
    public val username: Output<String>
        get() = javaResource.username().applyValue({ args0 -> args0 })

    /**
     * List of VPC security groups to
     * associate.
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.aws.rds.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit):
    Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
