@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.OptionGroupOption
import com.pulumi.aws.rds.kotlin.outputs.OptionGroupOption.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [OptionGroup].
 */
@PulumiTagMarker
public class OptionGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OptionGroupArgs = OptionGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OptionGroupArgsBuilder.() -> Unit) {
        val builder = OptionGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OptionGroup {
        val builtJavaResource = com.pulumi.aws.rds.OptionGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OptionGroup(builtJavaResource)
    }
}

/**
 * Provides an RDS DB option group resource. Documentation of the available options for various RDS engines can be found at:
 * * [MariaDB Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MariaDB.Options.html)
 * * [Microsoft SQL Server Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.Options.html)
 * * [MySQL Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MySQL.Options.html)
 * * [Oracle Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.Options.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.OptionGroup;
 * import com.pulumi.aws.rds.OptionGroupArgs;
 * import com.pulumi.aws.rds.inputs.OptionGroupOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OptionGroup("example", OptionGroupArgs.builder()
 *             .optionGroupDescription("Option Group")
 *             .engineName("sqlserver-ee")
 *             .majorEngineVersion("11.00")
 *             .options(
 *                 OptionGroupOptionArgs.builder()
 *                     .optionName("Timezone")
 *                     .optionSettings(OptionGroupOptionOptionSettingArgs.builder()
 *                         .name("TIME_ZONE")
 *                         .value("UTC")
 *                         .build())
 *                     .build(),
 *                 OptionGroupOptionArgs.builder()
 *                     .optionName("SQLSERVER_BACKUP_RESTORE")
 *                     .optionSettings(OptionGroupOptionOptionSettingArgs.builder()
 *                         .name("IAM_ROLE_ARN")
 *                         .value(aws_iam_role.example().arn())
 *                         .build())
 *                     .build(),
 *                 OptionGroupOptionArgs.builder()
 *                     .optionName("TDE")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DB option groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:rds/optionGroup:OptionGroup example mysql-option-group
 * ```
 *
 */
public class OptionGroup internal constructor(
    override val javaResource: com.pulumi.aws.rds.OptionGroup,
) : KotlinCustomResource(javaResource, OptionGroupMapper) {
    /**
     * ARN of the DB option group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the engine that this option group should be associated with.
     */
    public val engineName: Output<String>
        get() = javaResource.engineName().applyValue({ args0 -> args0 })

    /**
     * Specifies the major version of the engine that this option group should be associated with.
     */
    public val majorEngineVersion: Output<String>
        get() = javaResource.majorEngineVersion().applyValue({ args0 -> args0 })

    /**
     * Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Description of the option group.
     */
    public val optionGroupDescription: Output<String>
        get() = javaResource.optionGroupDescription().applyValue({ args0 -> args0 })

    /**
     * List of options to apply.
     */
    public val options: Output<List<OptionGroupOption>>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object OptionGroupMapper : ResourceMapper<OptionGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.OptionGroup::class == javaResource::class

    override fun map(javaResource: Resource): OptionGroup = OptionGroup(
        javaResource as
            com.pulumi.aws.rds.OptionGroup,
    )
}

/**
 * @see [OptionGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OptionGroup].
 */
public suspend fun optionGroup(name: String, block: suspend OptionGroupResourceBuilder.() -> Unit):
    OptionGroup {
    val builder = OptionGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OptionGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun optionGroup(name: String): OptionGroup {
    val builder = OptionGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
