@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.OptionGroupArgs.builder
import com.pulumi.aws.rds.kotlin.inputs.OptionGroupOptionArgs
import com.pulumi.aws.rds.kotlin.inputs.OptionGroupOptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an RDS DB option group resource. Documentation of the available options for various RDS engines can be found at:
 * * [MariaDB Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MariaDB.Options.html)
 * * [Microsoft SQL Server Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.Options.html)
 * * [MySQL Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MySQL.Options.html)
 * * [Oracle Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.Options.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.OptionGroup;
 * import com.pulumi.aws.rds.OptionGroupArgs;
 * import com.pulumi.aws.rds.inputs.OptionGroupOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OptionGroup("example", OptionGroupArgs.builder()
 *             .optionGroupDescription("Option Group")
 *             .engineName("sqlserver-ee")
 *             .majorEngineVersion("11.00")
 *             .options(
 *                 OptionGroupOptionArgs.builder()
 *                     .optionName("Timezone")
 *                     .optionSettings(OptionGroupOptionOptionSettingArgs.builder()
 *                         .name("TIME_ZONE")
 *                         .value("UTC")
 *                         .build())
 *                     .build(),
 *                 OptionGroupOptionArgs.builder()
 *                     .optionName("SQLSERVER_BACKUP_RESTORE")
 *                     .optionSettings(OptionGroupOptionOptionSettingArgs.builder()
 *                         .name("IAM_ROLE_ARN")
 *                         .value(aws_iam_role.example().arn())
 *                         .build())
 *                     .build(),
 *                 OptionGroupOptionArgs.builder()
 *                     .optionName("TDE")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DB option groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:rds/optionGroup:OptionGroup example mysql-option-group
 * ```
 * @property engineName Specifies the name of the engine that this option group should be associated with.
 * @property majorEngineVersion Specifies the major version of the engine that this option group should be associated with.
 * @property name Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
 * @property optionGroupDescription Description of the option group.
 * @property options List of options to apply.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class OptionGroupArgs(
    public val engineName: Output<String>? = null,
    public val majorEngineVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val optionGroupDescription: Output<String>? = null,
    public val options: Output<List<OptionGroupOptionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.OptionGroupArgs> {
    override fun toJava(): com.pulumi.aws.rds.OptionGroupArgs =
        com.pulumi.aws.rds.OptionGroupArgs.builder()
            .engineName(engineName?.applyValue({ args0 -> args0 }))
            .majorEngineVersion(majorEngineVersion?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .optionGroupDescription(optionGroupDescription?.applyValue({ args0 -> args0 }))
            .options(
                options?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OptionGroupArgs].
 */
@PulumiTagMarker
public class OptionGroupArgsBuilder internal constructor() {
    private var engineName: Output<String>? = null

    private var majorEngineVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var optionGroupDescription: Output<String>? = null

    private var options: Output<List<OptionGroupOptionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the name of the engine that this option group should be associated with.
     */
    @JvmName("mncugqnrdnqdciwq")
    public suspend fun engineName(`value`: Output<String>) {
        this.engineName = value
    }

    /**
     * @param value Specifies the major version of the engine that this option group should be associated with.
     */
    @JvmName("kcytjtnskmmuqdnf")
    public suspend fun majorEngineVersion(`value`: Output<String>) {
        this.majorEngineVersion = value
    }

    /**
     * @param value Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
     */
    @JvmName("bsrjcqugneciwina")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
     */
    @JvmName("pivufxyehsewweiq")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Description of the option group.
     */
    @JvmName("rjlnmsjgbcmyhasi")
    public suspend fun optionGroupDescription(`value`: Output<String>) {
        this.optionGroupDescription = value
    }

    /**
     * @param value List of options to apply.
     */
    @JvmName("tsedplqjibnoxtwj")
    public suspend fun options(`value`: Output<List<OptionGroupOptionArgs>>) {
        this.options = value
    }

    @JvmName("gnahovnwsicafbyg")
    public suspend fun options(vararg values: Output<OptionGroupOptionArgs>) {
        this.options = Output.all(values.asList())
    }

    /**
     * @param values List of options to apply.
     */
    @JvmName("yoncuduornjevdhp")
    public suspend fun options(values: List<Output<OptionGroupOptionArgs>>) {
        this.options = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jojujmegmjukneme")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the name of the engine that this option group should be associated with.
     */
    @JvmName("einapsdxiutdsuen")
    public suspend fun engineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineName = mapped
    }

    /**
     * @param value Specifies the major version of the engine that this option group should be associated with.
     */
    @JvmName("aefflgjebitshfrx")
    public suspend fun majorEngineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.majorEngineVersion = mapped
    }

    /**
     * @param value Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
     */
    @JvmName("nyfoqmeqhecquvuv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
     */
    @JvmName("tpscbhvpfrkprcee")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Description of the option group.
     */
    @JvmName("egxmbftjxkrpacbp")
    public suspend fun optionGroupDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionGroupDescription = mapped
    }

    /**
     * @param value List of options to apply.
     */
    @JvmName("wuovjiguyysdewwq")
    public suspend fun options(`value`: List<OptionGroupOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument List of options to apply.
     */
    @JvmName("wqkbxbqgojcghkle")
    public suspend fun options(argument: List<suspend OptionGroupOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OptionGroupOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param argument List of options to apply.
     */
    @JvmName("mafxkdgnfeqqcgmh")
    public suspend fun options(vararg argument: suspend OptionGroupOptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OptionGroupOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param argument List of options to apply.
     */
    @JvmName("wpansptreynkgnmr")
    public suspend fun options(argument: suspend OptionGroupOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OptionGroupOptionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param values List of options to apply.
     */
    @JvmName("ardybrjqqnblihhg")
    public suspend fun options(vararg values: OptionGroupOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qphmjogovhauknhx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rcibmeaavrmtndku")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): OptionGroupArgs = OptionGroupArgs(
        engineName = engineName,
        majorEngineVersion = majorEngineVersion,
        name = name,
        namePrefix = namePrefix,
        optionGroupDescription = optionGroupDescription,
        options = options,
        tags = tags,
    )
}
