@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.ParameterGroupParameter
import com.pulumi.aws.rds.kotlin.outputs.ParameterGroupParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ParameterGroup].
 */
@PulumiTagMarker
public class ParameterGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ParameterGroupArgs = ParameterGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ParameterGroupArgsBuilder.() -> Unit) {
        val builder = ParameterGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ParameterGroup {
        val builtJavaResource = com.pulumi.aws.rds.ParameterGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ParameterGroup(builtJavaResource)
    }
}

/**
 * Provides an RDS DB parameter group resource. Documentation of the available parameters for various RDS engines can be found at:
 * * [Aurora MySQL Parameters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Reference.html)
 * * [Aurora PostgreSQL Parameters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraPostgreSQL.Reference.html)
 * * [MariaDB Parameters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MariaDB.Parameters.html)
 * * [Oracle Parameters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ModifyInstance.Oracle.html#USER_ModifyInstance.Oracle.sqlnet)
 * * [PostgreSQL Parameters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.PostgreSQL.CommonDBATasks.html#Appendix.PostgreSQL.CommonDBATasks.Parameters)
 * > **NOTE:** After applying your changes, you may encounter a perpetual diff in your pulumi preview
 * output for a `parameter` whose `value` remains unchanged but whose `apply_method` is changing
 * (e.g., from `immediate` to `pending-reboot`, or `pending-reboot` to `immediate`). If only the
 * apply method of a parameter is changing, the AWS API will not register this change. To change
 * the `apply_method` of a parameter, its value must also change.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ParameterGroup;
 * import com.pulumi.aws.rds.ParameterGroupArgs;
 * import com.pulumi.aws.rds.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new ParameterGroup("default", ParameterGroupArgs.builder()
 *             .family("mysql5.6")
 *             .parameters(
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("character_set_server")
 *                     .value("utf8")
 *                     .build(),
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("character_set_client")
 *                     .value("utf8")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### `create_before_destroy` Lifecycle Configuration
 * The `create_before_destroy`
 * lifecycle configuration is necessary for modifications that force re-creation of an existing,
 * in-use parameter group. This includes common situations like changing the group `name` or
 * bumping the `family` version during a major version upgrade. This configuration will prevent destruction
 * of the deposed parameter group while still in use by the database during upgrade.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ParameterGroup;
 * import com.pulumi.aws.rds.ParameterGroupArgs;
 * import com.pulumi.aws.rds.inputs.ParameterGroupParameterArgs;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleParameterGroup = new ParameterGroup("exampleParameterGroup", ParameterGroupArgs.builder()
 *             .family("postgres13")
 *             .parameters(ParameterGroupParameterArgs.builder()
 *                 .name("log_connections")
 *                 .value("1")
 *                 .build())
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .parameterGroupName(exampleParameterGroup.name())
 *             .applyImmediately(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DB Parameter groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:rds/parameterGroup:ParameterGroup rds_pg rds-pg
 * ```
 *
 */
public class ParameterGroup internal constructor(
    override val javaResource: com.pulumi.aws.rds.ParameterGroup,
) : KotlinCustomResource(javaResource, ParameterGroupMapper) {
    /**
     * The ARN of the db parameter group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the DB parameter group. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The family of the DB parameter group.
     */
    public val family: Output<String>
        get() = javaResource.family().applyValue({ args0 -> args0 })

    /**
     * The name of the DB parameter.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * A list of DB parameters to apply. Note that parameters may differ from a family to an other. Full list of all parameters can be discovered via [`aws rds describe-db-parameters`](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-parameters.html) after initial creation of the group.
     */
    public val parameters: Output<List<ParameterGroupParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ParameterGroupMapper : ResourceMapper<ParameterGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ParameterGroup::class == javaResource::class

    override fun map(javaResource: Resource): ParameterGroup = ParameterGroup(
        javaResource as
            com.pulumi.aws.rds.ParameterGroup,
    )
}

/**
 * @see [ParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ParameterGroup].
 */
public suspend fun parameterGroup(
    name: String,
    block: suspend ParameterGroupResourceBuilder.() -> Unit,
): ParameterGroup {
    val builder = ParameterGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun parameterGroup(name: String): ParameterGroup {
    val builder = ParameterGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
