@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.ProxyAuth
import com.pulumi.aws.rds.kotlin.outputs.ProxyAuth.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Proxy].
 */
@PulumiTagMarker
public class ProxyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProxyArgs = ProxyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProxyArgsBuilder.() -> Unit) {
        val builder = ProxyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Proxy {
        val builtJavaResource = com.pulumi.aws.rds.Proxy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Proxy(builtJavaResource)
    }
}

/**
 * Provides an RDS DB proxy resource. For additional information, see the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Proxy;
 * import com.pulumi.aws.rds.ProxyArgs;
 * import com.pulumi.aws.rds.inputs.ProxyAuthArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Proxy("example", ProxyArgs.builder()
 *             .debugLogging(false)
 *             .engineFamily("MYSQL")
 *             .idleClientTimeout(1800)
 *             .requireTls(true)
 *             .roleArn(aws_iam_role.example().arn())
 *             .vpcSecurityGroupIds(aws_security_group.example().id())
 *             .vpcSubnetIds(aws_subnet.example().id())
 *             .auths(ProxyAuthArgs.builder()
 *                 .authScheme("SECRETS")
 *                 .description("example")
 *                 .iamAuth("DISABLED")
 *                 .secretArn(aws_secretsmanager_secret.example().arn())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DB proxies using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:rds/proxy:Proxy example example
 * ```
 *
 */
public class Proxy internal constructor(
    override val javaResource: com.pulumi.aws.rds.Proxy,
) : KotlinCustomResource(javaResource, ProxyMapper) {
    /**
     * The Amazon Resource Name (ARN) for the proxy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    public val auths: Output<List<ProxyAuth>>
        get() = javaResource.auths().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
     */
    public val debugLogging: Output<Boolean>?
        get() = javaResource.debugLogging().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The endpoint that you can use to connect to the proxy. You include the endpoint value in the connection string for a database client application.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`. Valid values are `MYSQL`, `POSTGRESQL`, and `SQLSERVER`.
     */
    public val engineFamily: Output<String>
        get() = javaResource.engineFamily().applyValue({ args0 -> args0 })

    /**
     * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.
     */
    public val idleClientTimeout: Output<Int>
        get() = javaResource.idleClientTimeout().applyValue({ args0 -> args0 })

    /**
     * The identifier for the proxy. This name must be unique for all proxies owned by your AWS account in the specified AWS Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    public val requireTls: Output<Boolean>?
        get() = javaResource.requireTls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * One or more VPC security group IDs to associate with the new proxy.
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * One or more VPC subnet IDs to associate with the new proxy.
     */
    public val vpcSubnetIds: Output<List<String>>
        get() = javaResource.vpcSubnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ProxyMapper : ResourceMapper<Proxy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.Proxy::class == javaResource::class

    override fun map(javaResource: Resource): Proxy = Proxy(javaResource as com.pulumi.aws.rds.Proxy)
}

/**
 * @see [Proxy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Proxy].
 */
public suspend fun proxy(name: String, block: suspend ProxyResourceBuilder.() -> Unit): Proxy {
    val builder = ProxyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Proxy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun proxy(name: String): Proxy {
    val builder = ProxyResourceBuilder()
    builder.name(name)
    return builder.build()
}
