@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ProxyArgs.builder
import com.pulumi.aws.rds.kotlin.inputs.ProxyAuthArgs
import com.pulumi.aws.rds.kotlin.inputs.ProxyAuthArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an RDS DB proxy resource. For additional information, see the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Proxy;
 * import com.pulumi.aws.rds.ProxyArgs;
 * import com.pulumi.aws.rds.inputs.ProxyAuthArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Proxy("example", ProxyArgs.builder()
 *             .debugLogging(false)
 *             .engineFamily("MYSQL")
 *             .idleClientTimeout(1800)
 *             .requireTls(true)
 *             .roleArn(aws_iam_role.example().arn())
 *             .vpcSecurityGroupIds(aws_security_group.example().id())
 *             .vpcSubnetIds(aws_subnet.example().id())
 *             .auths(ProxyAuthArgs.builder()
 *                 .authScheme("SECRETS")
 *                 .description("example")
 *                 .iamAuth("DISABLED")
 *                 .secretArn(aws_secretsmanager_secret.example().arn())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DB proxies using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:rds/proxy:Proxy example example
 * ```
 * @property auths Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
 * @property debugLogging Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
 * @property engineFamily The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`. Valid values are `MYSQL`, `POSTGRESQL`, and `SQLSERVER`.
 * @property idleClientTimeout The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.
 * @property name The identifier for the proxy. This name must be unique for all proxies owned by your AWS account in the specified AWS Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
 * @property requireTls A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.
 * @property roleArn The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
 * @property tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
 * @property vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy.
 */
public data class ProxyArgs(
    public val auths: Output<List<ProxyAuthArgs>>? = null,
    public val debugLogging: Output<Boolean>? = null,
    public val engineFamily: Output<String>? = null,
    public val idleClientTimeout: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val requireTls: Output<Boolean>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
    public val vpcSubnetIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ProxyArgs> {
    override fun toJava(): com.pulumi.aws.rds.ProxyArgs = com.pulumi.aws.rds.ProxyArgs.builder()
        .auths(auths?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .debugLogging(debugLogging?.applyValue({ args0 -> args0 }))
        .engineFamily(engineFamily?.applyValue({ args0 -> args0 }))
        .idleClientTimeout(idleClientTimeout?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .requireTls(requireTls?.applyValue({ args0 -> args0 }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .vpcSecurityGroupIds(vpcSecurityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .vpcSubnetIds(vpcSubnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProxyArgs].
 */
@PulumiTagMarker
public class ProxyArgsBuilder internal constructor() {
    private var auths: Output<List<ProxyAuthArgs>>? = null

    private var debugLogging: Output<Boolean>? = null

    private var engineFamily: Output<String>? = null

    private var idleClientTimeout: Output<Int>? = null

    private var name: Output<String>? = null

    private var requireTls: Output<Boolean>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    private var vpcSubnetIds: Output<List<String>>? = null

    /**
     * @param value Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("mlqohfamjpkkejiq")
    public suspend fun auths(`value`: Output<List<ProxyAuthArgs>>) {
        this.auths = value
    }

    @JvmName("hmjpagoohxtnfymq")
    public suspend fun auths(vararg values: Output<ProxyAuthArgs>) {
        this.auths = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("qhcniveqyaklorfy")
    public suspend fun auths(values: List<Output<ProxyAuthArgs>>) {
        this.auths = Output.all(values)
    }

    /**
     * @param value Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
     */
    @JvmName("sfklaprlgwgbdtmi")
    public suspend fun debugLogging(`value`: Output<Boolean>) {
        this.debugLogging = value
    }

    /**
     * @param value The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`. Valid values are `MYSQL`, `POSTGRESQL`, and `SQLSERVER`.
     */
    @JvmName("afinpdygrjddvpjy")
    public suspend fun engineFamily(`value`: Output<String>) {
        this.engineFamily = value
    }

    /**
     * @param value The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.
     */
    @JvmName("vntoqxapstbcmrwb")
    public suspend fun idleClientTimeout(`value`: Output<Int>) {
        this.idleClientTimeout = value
    }

    /**
     * @param value The identifier for the proxy. This name must be unique for all proxies owned by your AWS account in the specified AWS Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    @JvmName("prbgejckglnfuvlt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    @JvmName("otwgfmpmpseonbgb")
    public suspend fun requireTls(`value`: Output<Boolean>) {
        this.requireTls = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
     */
    @JvmName("hqgcsyldxnipgfne")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wbvjbqodqfubgixf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("vhabfxnrfmukdfce")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("ndyawypixbubimvp")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("ebuxhcwtuglttafq")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("fmeganxhronofqkr")
    public suspend fun vpcSubnetIds(`value`: Output<List<String>>) {
        this.vpcSubnetIds = value
    }

    @JvmName("foftiijmdodxodwp")
    public suspend fun vpcSubnetIds(vararg values: Output<String>) {
        this.vpcSubnetIds = Output.all(values.asList())
    }

    /**
     * @param values One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("utceplcuhrlrnivm")
    public suspend fun vpcSubnetIds(values: List<Output<String>>) {
        this.vpcSubnetIds = Output.all(values)
    }

    /**
     * @param value Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("jftuoadfpxjoesqo")
    public suspend fun auths(`value`: List<ProxyAuthArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auths = mapped
    }

    /**
     * @param argument Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("dfyymaqsvijwwbfv")
    public suspend fun auths(argument: List<suspend ProxyAuthArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ProxyAuthArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.auths = mapped
    }

    /**
     * @param argument Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("aeiswgmodfrgpnij")
    public suspend fun auths(vararg argument: suspend ProxyAuthArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ProxyAuthArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.auths = mapped
    }

    /**
     * @param argument Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("sdhunrkungtpqigu")
    public suspend fun auths(argument: suspend ProxyAuthArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ProxyAuthArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.auths = mapped
    }

    /**
     * @param values Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("lkwldcifoxwiqxbv")
    public suspend fun auths(vararg values: ProxyAuthArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auths = mapped
    }

    /**
     * @param value Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
     */
    @JvmName("dcsbrxtvfmkpeuee")
    public suspend fun debugLogging(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.debugLogging = mapped
    }

    /**
     * @param value The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`. Valid values are `MYSQL`, `POSTGRESQL`, and `SQLSERVER`.
     */
    @JvmName("kkddgnynuftkdwyh")
    public suspend fun engineFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineFamily = mapped
    }

    /**
     * @param value The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.
     */
    @JvmName("durehpdyljygxxoh")
    public suspend fun idleClientTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleClientTimeout = mapped
    }

    /**
     * @param value The identifier for the proxy. This name must be unique for all proxies owned by your AWS account in the specified AWS Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    @JvmName("lpueftnwyhijvhwo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    @JvmName("qyglqxgixqchjpyr")
    public suspend fun requireTls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireTls = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
     */
    @JvmName("kkxudwdahfoyjayd")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mogmaxdypnwakmqg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gwignsvtncrkxuoq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("pgamriuitasjnerr")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("yscgifpkjdcsytbb")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param value One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("cnkdsxrlaeyddlxj")
    public suspend fun vpcSubnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSubnetIds = mapped
    }

    /**
     * @param values One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("srkasarkeklpbisw")
    public suspend fun vpcSubnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSubnetIds = mapped
    }

    internal fun build(): ProxyArgs = ProxyArgs(
        auths = auths,
        debugLogging = debugLogging,
        engineFamily = engineFamily,
        idleClientTimeout = idleClientTimeout,
        name = name,
        requireTls = requireTls,
        roleArn = roleArn,
        tags = tags,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
        vpcSubnetIds = vpcSubnetIds,
    )
}
