@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.ProxyDefaultTargetGroupConnectionPoolConfig
import com.pulumi.aws.rds.kotlin.outputs.ProxyDefaultTargetGroupConnectionPoolConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProxyDefaultTargetGroup].
 */
@PulumiTagMarker
public class ProxyDefaultTargetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProxyDefaultTargetGroupArgs = ProxyDefaultTargetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProxyDefaultTargetGroupArgsBuilder.() -> Unit) {
        val builder = ProxyDefaultTargetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProxyDefaultTargetGroup {
        val builtJavaResource = com.pulumi.aws.rds.ProxyDefaultTargetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProxyDefaultTargetGroup(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an RDS DB proxy default target group resource.
 * The `aws.rds.ProxyDefaultTargetGroup` behaves differently from normal resources, in that the provider does not _create_ or _destroy_ this resource, since it implicitly exists as part of an RDS DB Proxy. On the provider resource creation it is automatically imported and on resource destruction, the provider performs no actions in RDS.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Proxy;
 * import com.pulumi.aws.rds.ProxyArgs;
 * import com.pulumi.aws.rds.inputs.ProxyAuthArgs;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroup;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs;
 * import com.pulumi.aws.rds.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleProxy = new Proxy("exampleProxy", ProxyArgs.builder()
 *             .debugLogging(false)
 *             .engineFamily("MYSQL")
 *             .idleClientTimeout(1800)
 *             .requireTls(true)
 *             .roleArn(aws_iam_role.example().arn())
 *             .vpcSecurityGroupIds(aws_security_group.example().id())
 *             .vpcSubnetIds(aws_subnet.example().id())
 *             .auths(ProxyAuthArgs.builder()
 *                 .authScheme("SECRETS")
 *                 .description("example")
 *                 .iamAuth("DISABLED")
 *                 .secretArn(aws_secretsmanager_secret.example().arn())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *         var exampleProxyDefaultTargetGroup = new ProxyDefaultTargetGroup("exampleProxyDefaultTargetGroup", ProxyDefaultTargetGroupArgs.builder()
 *             .dbProxyName(exampleProxy.name())
 *             .connectionPoolConfig(ProxyDefaultTargetGroupConnectionPoolConfigArgs.builder()
 *                 .connectionBorrowTimeout(120)
 *                 .initQuery("SET x=1, y=2")
 *                 .maxConnectionsPercent(100)
 *                 .maxIdleConnectionsPercent(50)
 *                 .sessionPinningFilters("EXCLUDE_VARIABLE_SETS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DB proxy default target groups using the `db_proxy_name`. For example:
 * ```sh
 *  $ pulumi import aws:rds/proxyDefaultTargetGroup:ProxyDefaultTargetGroup example example
 * ```
 *
 */
public class ProxyDefaultTargetGroup internal constructor(
    override val javaResource: com.pulumi.aws.rds.ProxyDefaultTargetGroup,
) : KotlinCustomResource(javaResource, ProxyDefaultTargetGroupMapper) {
    /**
     * The Amazon Resource Name (ARN) representing the target group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The settings that determine the size and behavior of the connection pool for the target group.
     */
    public val connectionPoolConfig: Output<ProxyDefaultTargetGroupConnectionPoolConfig>
        get() = javaResource.connectionPoolConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Name of the RDS DB Proxy.
     */
    public val dbProxyName: Output<String>
        get() = javaResource.dbProxyName().applyValue({ args0 -> args0 })

    /**
     * The name of the default target group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object ProxyDefaultTargetGroupMapper : ResourceMapper<ProxyDefaultTargetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ProxyDefaultTargetGroup::class == javaResource::class

    override fun map(javaResource: Resource): ProxyDefaultTargetGroup =
        ProxyDefaultTargetGroup(javaResource as com.pulumi.aws.rds.ProxyDefaultTargetGroup)
}

/**
 * @see [ProxyDefaultTargetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProxyDefaultTargetGroup].
 */
public suspend fun proxyDefaultTargetGroup(
    name: String,
    block: suspend ProxyDefaultTargetGroupResourceBuilder.() -> Unit,
): ProxyDefaultTargetGroup {
    val builder = ProxyDefaultTargetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProxyDefaultTargetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun proxyDefaultTargetGroup(name: String): ProxyDefaultTargetGroup {
    val builder = ProxyDefaultTargetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
