@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs.builder
import com.pulumi.aws.rds.kotlin.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs
import com.pulumi.aws.rds.kotlin.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an RDS DB proxy default target group resource.
 * The `aws.rds.ProxyDefaultTargetGroup` behaves differently from normal resources, in that the provider does not _create_ or _destroy_ this resource, since it implicitly exists as part of an RDS DB Proxy. On the provider resource creation it is automatically imported and on resource destruction, the provider performs no actions in RDS.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Proxy;
 * import com.pulumi.aws.rds.ProxyArgs;
 * import com.pulumi.aws.rds.inputs.ProxyAuthArgs;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroup;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs;
 * import com.pulumi.aws.rds.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleProxy = new Proxy("exampleProxy", ProxyArgs.builder()
 *             .debugLogging(false)
 *             .engineFamily("MYSQL")
 *             .idleClientTimeout(1800)
 *             .requireTls(true)
 *             .roleArn(aws_iam_role.example().arn())
 *             .vpcSecurityGroupIds(aws_security_group.example().id())
 *             .vpcSubnetIds(aws_subnet.example().id())
 *             .auths(ProxyAuthArgs.builder()
 *                 .authScheme("SECRETS")
 *                 .description("example")
 *                 .iamAuth("DISABLED")
 *                 .secretArn(aws_secretsmanager_secret.example().arn())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *         var exampleProxyDefaultTargetGroup = new ProxyDefaultTargetGroup("exampleProxyDefaultTargetGroup", ProxyDefaultTargetGroupArgs.builder()
 *             .dbProxyName(exampleProxy.name())
 *             .connectionPoolConfig(ProxyDefaultTargetGroupConnectionPoolConfigArgs.builder()
 *                 .connectionBorrowTimeout(120)
 *                 .initQuery("SET x=1, y=2")
 *                 .maxConnectionsPercent(100)
 *                 .maxIdleConnectionsPercent(50)
 *                 .sessionPinningFilters("EXCLUDE_VARIABLE_SETS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DB proxy default target groups using the `db_proxy_name`. For example:
 * ```sh
 *  $ pulumi import aws:rds/proxyDefaultTargetGroup:ProxyDefaultTargetGroup example example
 * ```
 * @property connectionPoolConfig The settings that determine the size and behavior of the connection pool for the target group.
 * @property dbProxyName Name of the RDS DB Proxy.
 */
public data class ProxyDefaultTargetGroupArgs(
    public val connectionPoolConfig: Output<ProxyDefaultTargetGroupConnectionPoolConfigArgs>? = null,
    public val dbProxyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs> {
    override fun toJava(): com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs =
        com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs.builder()
            .connectionPoolConfig(
                connectionPoolConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dbProxyName(dbProxyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProxyDefaultTargetGroupArgs].
 */
@PulumiTagMarker
public class ProxyDefaultTargetGroupArgsBuilder internal constructor() {
    private var connectionPoolConfig: Output<ProxyDefaultTargetGroupConnectionPoolConfigArgs>? = null

    private var dbProxyName: Output<String>? = null

    /**
     * @param value The settings that determine the size and behavior of the connection pool for the target group.
     */
    @JvmName("tuxdlnrxxxpyvdqf")
    public suspend
    fun connectionPoolConfig(`value`: Output<ProxyDefaultTargetGroupConnectionPoolConfigArgs>) {
        this.connectionPoolConfig = value
    }

    /**
     * @param value Name of the RDS DB Proxy.
     */
    @JvmName("udpbcwdshfjaodom")
    public suspend fun dbProxyName(`value`: Output<String>) {
        this.dbProxyName = value
    }

    /**
     * @param value The settings that determine the size and behavior of the connection pool for the target group.
     */
    @JvmName("eyhcdhotupmrokts")
    public suspend
    fun connectionPoolConfig(`value`: ProxyDefaultTargetGroupConnectionPoolConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionPoolConfig = mapped
    }

    /**
     * @param argument The settings that determine the size and behavior of the connection pool for the target group.
     */
    @JvmName("lyrbsdjqnfstyipm")
    public suspend
    fun connectionPoolConfig(argument: suspend ProxyDefaultTargetGroupConnectionPoolConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProxyDefaultTargetGroupConnectionPoolConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.connectionPoolConfig = mapped
    }

    /**
     * @param value Name of the RDS DB Proxy.
     */
    @JvmName("pcxenssrftfilpba")
    public suspend fun dbProxyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbProxyName = mapped
    }

    internal fun build(): ProxyDefaultTargetGroupArgs = ProxyDefaultTargetGroupArgs(
        connectionPoolConfig = connectionPoolConfig,
        dbProxyName = dbProxyName,
    )
}
