@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ProxyTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an RDS DB proxy target resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Proxy;
 * import com.pulumi.aws.rds.ProxyArgs;
 * import com.pulumi.aws.rds.inputs.ProxyAuthArgs;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroup;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs;
 * import com.pulumi.aws.rds.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs;
 * import com.pulumi.aws.rds.ProxyTarget;
 * import com.pulumi.aws.rds.ProxyTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleProxy = new Proxy("exampleProxy", ProxyArgs.builder()
 *             .debugLogging(false)
 *             .engineFamily("MYSQL")
 *             .idleClientTimeout(1800)
 *             .requireTls(true)
 *             .roleArn(aws_iam_role.example().arn())
 *             .vpcSecurityGroupIds(aws_security_group.example().id())
 *             .vpcSubnetIds(aws_subnet.example().id())
 *             .auths(ProxyAuthArgs.builder()
 *                 .authScheme("SECRETS")
 *                 .description("example")
 *                 .iamAuth("DISABLED")
 *                 .secretArn(aws_secretsmanager_secret.example().arn())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *         var exampleProxyDefaultTargetGroup = new ProxyDefaultTargetGroup("exampleProxyDefaultTargetGroup", ProxyDefaultTargetGroupArgs.builder()
 *             .dbProxyName(exampleProxy.name())
 *             .connectionPoolConfig(ProxyDefaultTargetGroupConnectionPoolConfigArgs.builder()
 *                 .connectionBorrowTimeout(120)
 *                 .initQuery("SET x=1, y=2")
 *                 .maxConnectionsPercent(100)
 *                 .maxIdleConnectionsPercent(50)
 *                 .sessionPinningFilters("EXCLUDE_VARIABLE_SETS")
 *                 .build())
 *             .build());
 *         var exampleProxyTarget = new ProxyTarget("exampleProxyTarget", ProxyTargetArgs.builder()
 *             .dbInstanceIdentifier(aws_db_instance.example().identifier())
 *             .dbProxyName(exampleProxy.name())
 *             .targetGroupName(exampleProxyDefaultTargetGroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Provisioned Clusters:
 * __Using `pulumi import` to import__ RDS DB Proxy Targets using the `db_proxy_name`, `target_group_name`, target type (such as `RDS_INSTANCE` or `TRACKED_CLUSTER`), and resource identifier separated by forward slashes (`/`). For example:
 * Instances:
 * ```sh
 *  $ pulumi import aws:rds/proxyTarget:ProxyTarget example example-proxy/default/RDS_INSTANCE/example-instance
 * ```
 *  Provisioned Clusters:
 * ```sh
 *  $ pulumi import aws:rds/proxyTarget:ProxyTarget example example-proxy/default/TRACKED_CLUSTER/example-cluster
 * ```
 * @property dbClusterIdentifier DB cluster identifier.
 * **NOTE:** Either `db_instance_identifier` or `db_cluster_identifier` should be specified and both should not be specified together
 * @property dbInstanceIdentifier DB instance identifier.
 * @property dbProxyName The name of the DB proxy.
 * @property targetGroupName The name of the target group.
 */
public data class ProxyTargetArgs(
    public val dbClusterIdentifier: Output<String>? = null,
    public val dbInstanceIdentifier: Output<String>? = null,
    public val dbProxyName: Output<String>? = null,
    public val targetGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ProxyTargetArgs> {
    override fun toJava(): com.pulumi.aws.rds.ProxyTargetArgs =
        com.pulumi.aws.rds.ProxyTargetArgs.builder()
            .dbClusterIdentifier(dbClusterIdentifier?.applyValue({ args0 -> args0 }))
            .dbInstanceIdentifier(dbInstanceIdentifier?.applyValue({ args0 -> args0 }))
            .dbProxyName(dbProxyName?.applyValue({ args0 -> args0 }))
            .targetGroupName(targetGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProxyTargetArgs].
 */
@PulumiTagMarker
public class ProxyTargetArgsBuilder internal constructor() {
    private var dbClusterIdentifier: Output<String>? = null

    private var dbInstanceIdentifier: Output<String>? = null

    private var dbProxyName: Output<String>? = null

    private var targetGroupName: Output<String>? = null

    /**
     * @param value DB cluster identifier.
     * **NOTE:** Either `db_instance_identifier` or `db_cluster_identifier` should be specified and both should not be specified together
     */
    @JvmName("ntenudtvfieerker")
    public suspend fun dbClusterIdentifier(`value`: Output<String>) {
        this.dbClusterIdentifier = value
    }

    /**
     * @param value DB instance identifier.
     */
    @JvmName("juinnivofvvdaqgg")
    public suspend fun dbInstanceIdentifier(`value`: Output<String>) {
        this.dbInstanceIdentifier = value
    }

    /**
     * @param value The name of the DB proxy.
     */
    @JvmName("mercqupalmjokfym")
    public suspend fun dbProxyName(`value`: Output<String>) {
        this.dbProxyName = value
    }

    /**
     * @param value The name of the target group.
     */
    @JvmName("yobqsbtxguvfclvs")
    public suspend fun targetGroupName(`value`: Output<String>) {
        this.targetGroupName = value
    }

    /**
     * @param value DB cluster identifier.
     * **NOTE:** Either `db_instance_identifier` or `db_cluster_identifier` should be specified and both should not be specified together
     */
    @JvmName("iddvjroluhhacuiu")
    public suspend fun dbClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIdentifier = mapped
    }

    /**
     * @param value DB instance identifier.
     */
    @JvmName("yemdlsgusjmsvkjp")
    public suspend fun dbInstanceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIdentifier = mapped
    }

    /**
     * @param value The name of the DB proxy.
     */
    @JvmName("nxwgfdwmaaaoekab")
    public suspend fun dbProxyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbProxyName = mapped
    }

    /**
     * @param value The name of the target group.
     */
    @JvmName("leicvnbwoxtpplre")
    public suspend fun targetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupName = mapped
    }

    internal fun build(): ProxyTargetArgs = ProxyTargetArgs(
        dbClusterIdentifier = dbClusterIdentifier,
        dbInstanceIdentifier = dbInstanceIdentifier,
        dbProxyName = dbProxyName,
        targetGroupName = targetGroupName,
    )
}
