@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.RdsFunctions.getCertificatePlain
import com.pulumi.aws.rds.RdsFunctions.getClusterPlain
import com.pulumi.aws.rds.RdsFunctions.getClusterSnapshotPlain
import com.pulumi.aws.rds.RdsFunctions.getClustersPlain
import com.pulumi.aws.rds.RdsFunctions.getEngineVersionPlain
import com.pulumi.aws.rds.RdsFunctions.getEventCategoriesPlain
import com.pulumi.aws.rds.RdsFunctions.getInstancePlain
import com.pulumi.aws.rds.RdsFunctions.getInstancesPlain
import com.pulumi.aws.rds.RdsFunctions.getOrderableDbInstancePlain
import com.pulumi.aws.rds.RdsFunctions.getProxyPlain
import com.pulumi.aws.rds.RdsFunctions.getReservedInstanceOfferingPlain
import com.pulumi.aws.rds.RdsFunctions.getSnapshotPlain
import com.pulumi.aws.rds.RdsFunctions.getSubnetGroupPlain
import com.pulumi.aws.rds.kotlin.inputs.GetCertificatePlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetCertificatePlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetClusterSnapshotPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetClusterSnapshotPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetClustersFilter
import com.pulumi.aws.rds.kotlin.inputs.GetClustersPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetClustersPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetEngineVersionFilter
import com.pulumi.aws.rds.kotlin.inputs.GetEngineVersionPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetEngineVersionPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetEventCategoriesPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetEventCategoriesPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetInstancePlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetInstancePlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetInstancesFilter
import com.pulumi.aws.rds.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetOrderableDbInstancePlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetOrderableDbInstancePlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetProxyPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetProxyPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetReservedInstanceOfferingPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetReservedInstanceOfferingPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetSnapshotPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetSnapshotPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetSubnetGroupPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetSubnetGroupPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.outputs.GetCertificateResult
import com.pulumi.aws.rds.kotlin.outputs.GetClusterResult
import com.pulumi.aws.rds.kotlin.outputs.GetClusterSnapshotResult
import com.pulumi.aws.rds.kotlin.outputs.GetClustersResult
import com.pulumi.aws.rds.kotlin.outputs.GetEngineVersionResult
import com.pulumi.aws.rds.kotlin.outputs.GetEventCategoriesResult
import com.pulumi.aws.rds.kotlin.outputs.GetInstanceResult
import com.pulumi.aws.rds.kotlin.outputs.GetInstancesResult
import com.pulumi.aws.rds.kotlin.outputs.GetOrderableDbInstanceResult
import com.pulumi.aws.rds.kotlin.outputs.GetProxyResult
import com.pulumi.aws.rds.kotlin.outputs.GetReservedInstanceOfferingResult
import com.pulumi.aws.rds.kotlin.outputs.GetSnapshotResult
import com.pulumi.aws.rds.kotlin.outputs.GetSubnetGroupResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.rds.kotlin.outputs.GetCertificateResult.Companion.toKotlin as getCertificateResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetClusterSnapshotResult.Companion.toKotlin as getClusterSnapshotResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetClustersResult.Companion.toKotlin as getClustersResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetEngineVersionResult.Companion.toKotlin as getEngineVersionResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetEventCategoriesResult.Companion.toKotlin as getEventCategoriesResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetInstanceResult.Companion.toKotlin as getInstanceResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetOrderableDbInstanceResult.Companion.toKotlin as getOrderableDbInstanceResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetProxyResult.Companion.toKotlin as getProxyResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetReservedInstanceOfferingResult.Companion.toKotlin as getReservedInstanceOfferingResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetSnapshotResult.Companion.toKotlin as getSnapshotResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetSubnetGroupResult.Companion.toKotlin as getSubnetGroupResultToKotlin

public object RdsFunctions {
    /**
     * Information about an RDS Certificate.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetCertificateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getCertificate(GetCertificateArgs.builder()
     *             .latestValidTill(true)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCertificate.
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(argument: GetCertificatePlainArgs): GetCertificateResult =
        getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCertificate].
     * @param id Certificate identifier. For example, `rds-ca-2019`.
     * @param latestValidTill When enabled, returns the certificate with the latest `ValidTill`.
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(id: String? = null, latestValidTill: Boolean? = null):
        GetCertificateResult {
        val argument = GetCertificatePlainArgs(
            id = id,
            latestValidTill = latestValidTill,
        )
        return getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetCertificatePlainArgs].
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(argument: suspend GetCertificatePlainArgsBuilder.() -> Unit):
        GetCertificateResult {
        val builder = GetCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateResultToKotlin(getCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about an RDS cluster.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var clusterName = RdsFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterIdentifier("clusterName")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterIdentifier Cluster identifier of the RDS cluster.
     * @param tags A map of tags assigned to the resource.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(clusterIdentifier: String, tags: Map<String, String>? = null):
        GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterIdentifier = clusterIdentifier,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a DB Cluster Snapshot for use when provisioning DB clusters.
     * > **NOTE:** This data source does not apply to snapshots created on DB Instances.
     * See the `aws.rds.Snapshot` data source for DB Instance snapshots.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetClusterSnapshotArgs;
     * import com.pulumi.aws.rds.Cluster;
     * import com.pulumi.aws.rds.ClusterArgs;
     * import com.pulumi.aws.rds.ClusterInstance;
     * import com.pulumi.aws.rds.ClusterInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var developmentFinalSnapshot = RdsFunctions.getClusterSnapshot(GetClusterSnapshotArgs.builder()
     *             .dbClusterIdentifier("development_cluster")
     *             .mostRecent(true)
     *             .build());
     *         var auroraCluster = new Cluster("auroraCluster", ClusterArgs.builder()
     *             .clusterIdentifier("development_cluster")
     *             .snapshotIdentifier(developmentFinalSnapshot.applyValue(getClusterSnapshotResult -> getClusterSnapshotResult.id()))
     *             .dbSubnetGroupName("my_db_subnet_group")
     *             .build());
     *         var auroraClusterInstance = new ClusterInstance("auroraClusterInstance", ClusterInstanceArgs.builder()
     *             .clusterIdentifier(auroraCluster.id())
     *             .instanceClass("db.t2.small")
     *             .dbSubnetGroupName("my_db_subnet_group")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getClusterSnapshot.
     * @return A collection of values returned by getClusterSnapshot.
     */
    public suspend fun getClusterSnapshot(argument: GetClusterSnapshotPlainArgs):
        GetClusterSnapshotResult =
        getClusterSnapshotResultToKotlin(getClusterSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getClusterSnapshot].
     * @param dbClusterIdentifier Returns the list of snapshots created by the specific db_cluster
     * @param dbClusterSnapshotIdentifier Returns information on a specific snapshot_id.
     * @param includePublic Set this value to true to include manual DB Cluster Snapshots that are public and can be
     * copied or restored by any AWS account, otherwise set this value to false. The default is `false`.
     * @param includeShared Set this value to true to include shared manual DB Cluster Snapshots from other
     * AWS accounts that this AWS account has been given permission to copy or restore, otherwise set this value to false.
     * The default is `false`.
     * @param mostRecent If more than one result is returned, use the most recent Snapshot.
     * @param snapshotType Type of snapshots to be returned. If you don't specify a SnapshotType
     * value, then both automated and manual DB cluster snapshots are returned. Shared and public DB Cluster Snapshots are not
     * included in the returned results by default. Possible values are, `automated`, `manual`, `shared`, `public` and `awsbackup`.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired DB cluster snapshot.
     * @return A collection of values returned by getClusterSnapshot.
     */
    public suspend fun getClusterSnapshot(
        dbClusterIdentifier: String? = null,
        dbClusterSnapshotIdentifier: String? = null,
        includePublic: Boolean? = null,
        includeShared: Boolean? = null,
        mostRecent: Boolean? = null,
        snapshotType: String? = null,
        tags: Map<String, String>? = null,
    ): GetClusterSnapshotResult {
        val argument = GetClusterSnapshotPlainArgs(
            dbClusterIdentifier = dbClusterIdentifier,
            dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier,
            includePublic = includePublic,
            includeShared = includeShared,
            mostRecent = mostRecent,
            snapshotType = snapshotType,
            tags = tags,
        )
        return getClusterSnapshotResultToKotlin(getClusterSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetClusterSnapshotPlainArgs].
     * @return A collection of values returned by getClusterSnapshot.
     */
    public suspend
    fun getClusterSnapshot(argument: suspend GetClusterSnapshotPlainArgsBuilder.() -> Unit):
        GetClusterSnapshotResult {
        val builder = GetClusterSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterSnapshotResultToKotlin(getClusterSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS RDS (Relational Database) Clusters.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getClusters(GetClustersArgs.builder()
     *             .filters(GetClustersFilterArgs.builder()
     *                 .name("engine")
     *                 .values("aurora-postgresql")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getClusters.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: GetClustersPlainArgs): GetClustersResult =
        getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())

    /**
     * @see [getClusters].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(filters: List<GetClustersFilter>? = null): GetClustersResult {
        val argument = GetClustersPlainArgs(
            filters = filters,
        )
        return getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusters].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetClustersPlainArgs].
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: suspend GetClustersPlainArgsBuilder.() -> Unit):
        GetClustersResult {
        val builder = GetClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClustersResultToKotlin(getClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about an RDS engine version.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetEngineVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getEngineVersion(GetEngineVersionArgs.builder()
     *             .engine("mysql")
     *             .preferredVersions(
     *                 "8.0.27",
     *                 "8.0.26")
     *             .build());
     *     }
     * }
     * ```
     * ### With `filter`
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetEngineVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getEngineVersion(GetEngineVersionArgs.builder()
     *             .engine("aurora-postgresql")
     *             .filters(GetEngineVersionFilterArgs.builder()
     *                 .name("engine-mode")
     *                 .values("serverless")
     *                 .build())
     *             .includeAll(true)
     *             .version("10.14")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEngineVersion.
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend fun getEngineVersion(argument: GetEngineVersionPlainArgs): GetEngineVersionResult =
        getEngineVersionResultToKotlin(getEngineVersionPlain(argument.toJava()).await())

    /**
     * @see [getEngineVersion].
     * @param defaultOnly When set to `true`, the default version for the specified `engine` or combination of `engine` and major `version` will be returned. Can be used to limit responses to a single version when they would otherwise fail for returning multiple versions.
     * @param engine DB engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
     * @param filters One or more name/value pairs to filter off of. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     * @param includeAll When set to `true`, the specified `version` or member of `preferred_versions` will be returned even if it is `deprecated`. Otherwise, only `available` versions will be returned.
     * @param parameterGroupFamily Name of a specific DB parameter group family. Examples of parameter group families are `mysql8.0`, `mariadb10.4`, and `postgres12`.
     * @param preferredVersions Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     * @param version Version of the DB engine. For example, `5.7.22`, `10.1.34`, and `12.3`. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend fun getEngineVersion(
        defaultOnly: Boolean? = null,
        engine: String,
        filters: List<GetEngineVersionFilter>? = null,
        includeAll: Boolean? = null,
        parameterGroupFamily: String? = null,
        preferredVersions: List<String>? = null,
        version: String? = null,
    ): GetEngineVersionResult {
        val argument = GetEngineVersionPlainArgs(
            defaultOnly = defaultOnly,
            engine = engine,
            filters = filters,
            includeAll = includeAll,
            parameterGroupFamily = parameterGroupFamily,
            preferredVersions = preferredVersions,
            version = version,
        )
        return getEngineVersionResultToKotlin(getEngineVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEngineVersion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetEngineVersionPlainArgs].
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend
    fun getEngineVersion(argument: suspend GetEngineVersionPlainArgsBuilder.() -> Unit):
        GetEngineVersionResult {
        val builder = GetEngineVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEngineVersionResultToKotlin(getEngineVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * List the event categories of all the RDS resources.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetEventCategoriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleEventCategories = RdsFunctions.getEventCategories();
     *         ctx.export("example", exampleEventCategories.applyValue(getEventCategoriesResult -> getEventCategoriesResult.eventCategories()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEventCategories.
     * @return A collection of values returned by getEventCategories.
     */
    public suspend fun getEventCategories(argument: GetEventCategoriesPlainArgs):
        GetEventCategoriesResult =
        getEventCategoriesResultToKotlin(getEventCategoriesPlain(argument.toJava()).await())

    /**
     * @see [getEventCategories].
     * @param sourceType Type of source that will be generating the events. Valid options are db-instance, db-security-group, db-parameter-group, db-snapshot, db-cluster or db-cluster-snapshot.
     * @return A collection of values returned by getEventCategories.
     */
    public suspend fun getEventCategories(sourceType: String? = null): GetEventCategoriesResult {
        val argument = GetEventCategoriesPlainArgs(
            sourceType = sourceType,
        )
        return getEventCategoriesResultToKotlin(getEventCategoriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventCategories].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetEventCategoriesPlainArgs].
     * @return A collection of values returned by getEventCategories.
     */
    public suspend
    fun getEventCategories(argument: suspend GetEventCategoriesPlainArgsBuilder.() -> Unit):
        GetEventCategoriesResult {
        val builder = GetEventCategoriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventCategoriesResultToKotlin(getEventCategoriesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an RDS instance
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var database = RdsFunctions.getInstance(GetInstanceArgs.builder()
     *             .dbInstanceIdentifier("my-test-database")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstance.
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(argument: GetInstancePlainArgs): GetInstanceResult =
        getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())

    /**
     * @see [getInstance].
     * @param dbInstanceIdentifier Name of the RDS instance.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired instance.
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(
        dbInstanceIdentifier: String? = null,
        tags: Map<String, String>? =
            null,
    ): GetInstanceResult {
        val argument = GetInstancePlainArgs(
            dbInstanceIdentifier = dbInstanceIdentifier,
            tags = tags,
        )
        return getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstance].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetInstancePlainArgs].
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(argument: suspend GetInstancePlainArgsBuilder.() -> Unit):
        GetInstanceResult {
        val builder = GetInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceResultToKotlin(getInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for listing RDS Database Instances.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getInstances(GetInstancesArgs.builder()
     *             .filters(GetInstancesFilterArgs.builder()
     *                 .name("db-instance-id")
     *                 .values("my-database-id")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### Using tags
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getInstances(GetInstancesArgs.builder()
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param filters Configuration block(s) used to filter instances with AWS supported attributes, such as `engine`, `db-cluster-id` or `db-instance-id` for example. Detailed below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired instances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        filters: List<GetInstancesFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit):
        GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about RDS orderable DB instances and valid parameter combinations.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetOrderableDbInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getOrderableDbInstance(GetOrderableDbInstanceArgs.builder()
     *             .engine("mysql")
     *             .engineVersion("5.7.22")
     *             .licenseModel("general-public-license")
     *             .preferredInstanceClasses(
     *                 "db.r6.xlarge",
     *                 "db.m4.large",
     *                 "db.t3.small")
     *             .storageType("standard")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOrderableDbInstance.
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend fun getOrderableDbInstance(argument: GetOrderableDbInstancePlainArgs):
        GetOrderableDbInstanceResult =
        getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(argument.toJava()).await())

    /**
     * @see [getOrderableDbInstance].
     * @param availabilityZoneGroup Availability zone group.
     * @param engine DB engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
     * @param engineVersion Version of the DB engine. If none is provided, the AWS-defined default version will be used.
     * @param instanceClass DB instance class. Examples of classes are `db.m3.2xlarge`, `db.t2.small`, and `db.m3.medium`.
     * @param licenseModel License model. Examples of license models are `general-public-license`, `bring-your-own-license`, and `amazon-license`.
     * @param preferredEngineVersions Ordered list of preferred RDS DB instance engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     * @param preferredInstanceClasses Ordered list of preferred RDS DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     * @param storageType Storage types. Examples of storage types are `standard`, `io1`, `gp2`, and `aurora`.
     * @param supportsEnhancedMonitoring Enable this to ensure a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
     * @param supportsGlobalDatabases Enable this to ensure a DB instance supports Aurora global databases with a specific combination of other DB engine attributes.
     * @param supportsIamDatabaseAuthentication Enable this to ensure a DB instance supports IAM database authentication.
     * @param supportsIops Enable this to ensure a DB instance supports provisioned IOPS.
     * @param supportsKerberosAuthentication Enable this to ensure a DB instance supports Kerberos Authentication.
     * @param supportsPerformanceInsights Enable this to ensure a DB instance supports Performance Insights.
     * @param supportsStorageAutoscaling Enable this to ensure Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
     * @param supportsStorageEncryption Enable this to ensure a DB instance supports encrypted storage.
     * @param vpc Boolean that indicates whether to show only VPC or non-VPC offerings.
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend fun getOrderableDbInstance(
        availabilityZoneGroup: String? = null,
        engine: String,
        engineVersion: String? = null,
        instanceClass: String? = null,
        licenseModel: String? = null,
        preferredEngineVersions: List<String>? = null,
        preferredInstanceClasses: List<String>? = null,
        storageType: String? = null,
        supportsEnhancedMonitoring: Boolean? = null,
        supportsGlobalDatabases: Boolean? = null,
        supportsIamDatabaseAuthentication: Boolean? = null,
        supportsIops: Boolean? = null,
        supportsKerberosAuthentication: Boolean? = null,
        supportsPerformanceInsights: Boolean? = null,
        supportsStorageAutoscaling: Boolean? = null,
        supportsStorageEncryption: Boolean? = null,
        vpc: Boolean? = null,
    ): GetOrderableDbInstanceResult {
        val argument = GetOrderableDbInstancePlainArgs(
            availabilityZoneGroup = availabilityZoneGroup,
            engine = engine,
            engineVersion = engineVersion,
            instanceClass = instanceClass,
            licenseModel = licenseModel,
            preferredEngineVersions = preferredEngineVersions,
            preferredInstanceClasses = preferredInstanceClasses,
            storageType = storageType,
            supportsEnhancedMonitoring = supportsEnhancedMonitoring,
            supportsGlobalDatabases = supportsGlobalDatabases,
            supportsIamDatabaseAuthentication = supportsIamDatabaseAuthentication,
            supportsIops = supportsIops,
            supportsKerberosAuthentication = supportsKerberosAuthentication,
            supportsPerformanceInsights = supportsPerformanceInsights,
            supportsStorageAutoscaling = supportsStorageAutoscaling,
            supportsStorageEncryption = supportsStorageEncryption,
            vpc = vpc,
        )
        return getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getOrderableDbInstance].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetOrderableDbInstancePlainArgs].
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend
    fun getOrderableDbInstance(argument: suspend GetOrderableDbInstancePlainArgsBuilder.() -> Unit):
        GetOrderableDbInstanceResult {
        val builder = GetOrderableDbInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a DB Proxy.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetProxyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var proxy = RdsFunctions.getProxy(GetProxyArgs.builder()
     *             .name("my-test-db-proxy")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getProxy.
     * @return A collection of values returned by getProxy.
     */
    public suspend fun getProxy(argument: GetProxyPlainArgs): GetProxyResult =
        getProxyResultToKotlin(getProxyPlain(argument.toJava()).await())

    /**
     * @see [getProxy].
     * @param name Name of the DB proxy.
     * @return A collection of values returned by getProxy.
     */
    public suspend fun getProxy(name: String): GetProxyResult {
        val argument = GetProxyPlainArgs(
            name = name,
        )
        return getProxyResultToKotlin(getProxyPlain(argument.toJava()).await())
    }

    /**
     * @see [getProxy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetProxyPlainArgs].
     * @return A collection of values returned by getProxy.
     */
    public suspend fun getProxy(argument: suspend GetProxyPlainArgsBuilder.() -> Unit):
        GetProxyResult {
        val builder = GetProxyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProxyResultToKotlin(getProxyPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about a single RDS Reserved Instance Offering.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetReservedInstanceOfferingArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getReservedInstanceOffering(GetReservedInstanceOfferingArgs.builder()
     *             .dbInstanceClass("db.t2.micro")
     *             .duration(31536000)
     *             .multiAz(false)
     *             .offeringType("All Upfront")
     *             .productDescription("mysql")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getReservedInstanceOffering.
     * @return A collection of values returned by getReservedInstanceOffering.
     */
    public suspend fun getReservedInstanceOffering(argument: GetReservedInstanceOfferingPlainArgs):
        GetReservedInstanceOfferingResult =
        getReservedInstanceOfferingResultToKotlin(getReservedInstanceOfferingPlain(argument.toJava()).await())

    /**
     * @see [getReservedInstanceOffering].
     * @param dbInstanceClass DB instance class for the reserved DB instance.
     * @param duration Duration of the reservation in years or seconds. Valid values are `1`, `3`, `31536000`, `94608000`
     * @param multiAz Whether the reservation applies to Multi-AZ deployments.
     * @param offeringType Offering type of this reserved DB instance. Valid values are `No Upfront`, `Partial Upfront`, `All Upfront`.
     * @param productDescription Description of the reserved DB instance.
     * @return A collection of values returned by getReservedInstanceOffering.
     */
    public suspend fun getReservedInstanceOffering(
        dbInstanceClass: String,
        duration: Int,
        multiAz: Boolean,
        offeringType: String,
        productDescription: String,
    ): GetReservedInstanceOfferingResult {
        val argument = GetReservedInstanceOfferingPlainArgs(
            dbInstanceClass = dbInstanceClass,
            duration = duration,
            multiAz = multiAz,
            offeringType = offeringType,
            productDescription = productDescription,
        )
        return getReservedInstanceOfferingResultToKotlin(getReservedInstanceOfferingPlain(argument.toJava()).await())
    }

    /**
     * @see [getReservedInstanceOffering].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetReservedInstanceOfferingPlainArgs].
     * @return A collection of values returned by getReservedInstanceOffering.
     */
    public suspend
    fun getReservedInstanceOffering(argument: suspend GetReservedInstanceOfferingPlainArgsBuilder.() -> Unit):
        GetReservedInstanceOfferingResult {
        val builder = GetReservedInstanceOfferingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReservedInstanceOfferingResultToKotlin(getReservedInstanceOfferingPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a DB Snapshot for use when provisioning DB instances
     * > **NOTE:** This data source does not apply to snapshots created on Aurora DB clusters.
     * See the `aws.rds.ClusterSnapshot` data source for DB Cluster snapshots.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.Instance;
     * import com.pulumi.aws.rds.InstanceArgs;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetSnapshotArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var prod = new Instance("prod", InstanceArgs.builder()
     *             .allocatedStorage(10)
     *             .engine("mysql")
     *             .engineVersion("5.6.17")
     *             .instanceClass("db.t2.micro")
     *             .dbName("mydb")
     *             .username("foo")
     *             .password("bar")
     *             .dbSubnetGroupName("my_database_subnet_group")
     *             .parameterGroupName("default.mysql5.6")
     *             .build());
     *         final var latestProdSnapshot = RdsFunctions.getSnapshot(GetSnapshotArgs.builder()
     *             .dbInstanceIdentifier(prod.identifier())
     *             .mostRecent(true)
     *             .build());
     *         var dev = new Instance("dev", InstanceArgs.builder()
     *             .instanceClass("db.t2.micro")
     *             .dbName("mydbdev")
     *             .snapshotIdentifier(latestProdSnapshot.applyValue(getSnapshotResult -> getSnapshotResult).applyValue(latestProdSnapshot -> latestProdSnapshot.applyValue(getSnapshotResult -> getSnapshotResult.id())))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSnapshot.
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(argument: GetSnapshotPlainArgs): GetSnapshotResult =
        getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getSnapshot].
     * @param dbInstanceIdentifier Returns the list of snapshots created by the specific db_instance
     * @param dbSnapshotIdentifier Returns information on a specific snapshot_id.
     * @param includePublic Set this value to true to include manual DB snapshots that are public and can be
     * copied or restored by any AWS account, otherwise set this value to false. The default is `false`.
     * @param includeShared Set this value to true to include shared manual DB snapshots from other
     * AWS accounts that this AWS account has been given permission to copy or restore, otherwise set this value to false.
     * The default is `false`.
     * @param mostRecent If more than one result is returned, use the most
     * recent Snapshot.
     * @param snapshotType Type of snapshots to be returned. If you don't specify a SnapshotType
     * value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not
     * included in the returned results by default. Possible values are, `automated`, `manual`, `shared`, `public` and `awsbackup`.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired DB snapshot.
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(
        dbInstanceIdentifier: String? = null,
        dbSnapshotIdentifier: String? = null,
        includePublic: Boolean? = null,
        includeShared: Boolean? = null,
        mostRecent: Boolean? = null,
        snapshotType: String? = null,
        tags: Map<String, String>? = null,
    ): GetSnapshotResult {
        val argument = GetSnapshotPlainArgs(
            dbInstanceIdentifier = dbInstanceIdentifier,
            dbSnapshotIdentifier = dbSnapshotIdentifier,
            includePublic = includePublic,
            includeShared = includeShared,
            mostRecent = mostRecent,
            snapshotType = snapshotType,
            tags = tags,
        )
        return getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetSnapshotPlainArgs].
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(argument: suspend GetSnapshotPlainArgsBuilder.() -> Unit):
        GetSnapshotResult {
        val builder = GetSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotResultToKotlin(getSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an RDS subnet group.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var database = RdsFunctions.getSubnetGroup(GetSubnetGroupArgs.builder()
     *             .name("my-test-database-subnet-group")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSubnetGroup.
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: GetSubnetGroupPlainArgs): GetSubnetGroupResult =
        getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())

    /**
     * @see [getSubnetGroup].
     * @param name Name of the RDS database subnet group.
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(name: String): GetSubnetGroupResult {
        val argument = GetSubnetGroupPlainArgs(
            name = name,
        )
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetSubnetGroupPlainArgs].
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: suspend GetSubnetGroupPlainArgsBuilder.() -> Unit):
        GetSubnetGroupResult {
        val builder = GetSubnetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(builtArgument.toJava()).await())
    }
}
