@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.ReservedInstanceRecurringCharge
import com.pulumi.aws.rds.kotlin.outputs.ReservedInstanceRecurringCharge.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ReservedInstance].
 */
@PulumiTagMarker
public class ReservedInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReservedInstanceArgs = ReservedInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReservedInstanceArgsBuilder.() -> Unit) {
        val builder = ReservedInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReservedInstance {
        val builtJavaResource = com.pulumi.aws.rds.ReservedInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReservedInstance(builtJavaResource)
    }
}

/**
 * Manages an RDS DB Reserved Instance.
 * > **NOTE:** Once created, a reservation is valid for the `duration` of the provided `offering_id` and cannot be deleted. Performing a `destroy` will only remove the resource from state. For more information see [RDS Reserved Instances Documentation](https://aws&#46;amazon&#46;com/rds/reserved-instances/) and [PurchaseReservedDBInstancesOffering](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_PurchaseReservedDBInstancesOffering.html).
 * > **NOTE:** Due to the expense of testing this resource, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.RdsFunctions;
 * import com.pulumi.aws.rds.inputs.GetReservedInstanceOfferingArgs;
 * import com.pulumi.aws.rds.ReservedInstance;
 * import com.pulumi.aws.rds.ReservedInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = RdsFunctions.getReservedInstanceOffering(GetReservedInstanceOfferingArgs.builder()
 *             .dbInstanceClass("db.t2.micro")
 *             .duration(31536000)
 *             .multiAz(false)
 *             .offeringType("All Upfront")
 *             .productDescription("mysql")
 *             .build());
 *         var example = new ReservedInstance("example", ReservedInstanceArgs.builder()
 *             .offeringId(test.applyValue(getReservedInstanceOfferingResult -> getReservedInstanceOfferingResult.offeringId()))
 *             .reservationId("optionalCustomReservationID")
 *             .instanceCount(3)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RDS DB Instance Reservations using the `instance_id`. For example:
 * ```sh
 *  $ pulumi import aws:rds/reservedInstance:ReservedInstance reservation_instance CustomReservationID
 * ```
 *
 */
public class ReservedInstance internal constructor(
    override val javaResource: com.pulumi.aws.rds.ReservedInstance,
) : KotlinCustomResource(javaResource, ReservedInstanceMapper) {
    /**
     * ARN for the reserved DB instance.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Currency code for the reserved DB instance.
     */
    public val currencyCode: Output<String>
        get() = javaResource.currencyCode().applyValue({ args0 -> args0 })

    /**
     * DB instance class for the reserved DB instance.
     */
    public val dbInstanceClass: Output<String>
        get() = javaResource.dbInstanceClass().applyValue({ args0 -> args0 })

    /**
     * Duration of the reservation in seconds.
     */
    public val duration: Output<Int>
        get() = javaResource.duration().applyValue({ args0 -> args0 })

    /**
     * Fixed price charged for this reserved DB instance.
     */
    public val fixedPrice: Output<Double>
        get() = javaResource.fixedPrice().applyValue({ args0 -> args0 })

    /**
     * Number of instances to reserve. Default value is `1`.
     */
    public val instanceCount: Output<Int>?
        get() = javaResource.instanceCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique identifier for the lease associated with the reserved DB instance. Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.
     */
    public val leaseId: Output<String>
        get() = javaResource.leaseId().applyValue({ args0 -> args0 })

    /**
     * Whether the reservation applies to Multi-AZ deployments.
     */
    public val multiAz: Output<Boolean>
        get() = javaResource.multiAz().applyValue({ args0 -> args0 })

    /**
     * ID of the Reserved DB instance offering to purchase. To determine an `offering_id`, see the `aws.rds.getReservedInstanceOffering` data source.
     * The following arguments are optional:
     */
    public val offeringId: Output<String>
        get() = javaResource.offeringId().applyValue({ args0 -> args0 })

    /**
     * Offering type of this reserved DB instance.
     */
    public val offeringType: Output<String>
        get() = javaResource.offeringType().applyValue({ args0 -> args0 })

    /**
     * Description of the reserved DB instance.
     */
    public val productDescription: Output<String>
        get() = javaResource.productDescription().applyValue({ args0 -> args0 })

    /**
     * Recurring price charged to run this reserved DB instance.
     */
    public val recurringCharges: Output<List<ReservedInstanceRecurringCharge>>
        get() = javaResource.recurringCharges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * Customer-specified identifier to track this reservation.
     */
    public val reservationId: Output<String>?
        get() = javaResource.reservationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time the reservation started.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * State of the reserved DB instance.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the DB reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Hourly price charged for this reserved DB instance.
     */
    public val usagePrice: Output<Double>
        get() = javaResource.usagePrice().applyValue({ args0 -> args0 })
}

public object ReservedInstanceMapper : ResourceMapper<ReservedInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ReservedInstance::class == javaResource::class

    override fun map(javaResource: Resource): ReservedInstance = ReservedInstance(
        javaResource as
            com.pulumi.aws.rds.ReservedInstance,
    )
}

/**
 * @see [ReservedInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReservedInstance].
 */
public suspend fun reservedInstance(
    name: String,
    block: suspend ReservedInstanceResourceBuilder.() -> Unit,
): ReservedInstance {
    val builder = ReservedInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReservedInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun reservedInstance(name: String): ReservedInstance {
    val builder = ReservedInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
