@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ReservedInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an RDS DB Reserved Instance.
 * > **NOTE:** Once created, a reservation is valid for the `duration` of the provided `offering_id` and cannot be deleted. Performing a `destroy` will only remove the resource from state. For more information see [RDS Reserved Instances Documentation](https://aws&#46;amazon&#46;com/rds/reserved-instances/) and [PurchaseReservedDBInstancesOffering](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_PurchaseReservedDBInstancesOffering.html).
 * > **NOTE:** Due to the expense of testing this resource, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.RdsFunctions;
 * import com.pulumi.aws.rds.inputs.GetReservedInstanceOfferingArgs;
 * import com.pulumi.aws.rds.ReservedInstance;
 * import com.pulumi.aws.rds.ReservedInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = RdsFunctions.getReservedInstanceOffering(GetReservedInstanceOfferingArgs.builder()
 *             .dbInstanceClass("db.t2.micro")
 *             .duration(31536000)
 *             .multiAz(false)
 *             .offeringType("All Upfront")
 *             .productDescription("mysql")
 *             .build());
 *         var example = new ReservedInstance("example", ReservedInstanceArgs.builder()
 *             .offeringId(test.applyValue(getReservedInstanceOfferingResult -> getReservedInstanceOfferingResult.offeringId()))
 *             .reservationId("optionalCustomReservationID")
 *             .instanceCount(3)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RDS DB Instance Reservations using the `instance_id`. For example:
 * ```sh
 *  $ pulumi import aws:rds/reservedInstance:ReservedInstance reservation_instance CustomReservationID
 * ```
 * @property instanceCount Number of instances to reserve. Default value is `1`.
 * @property offeringId ID of the Reserved DB instance offering to purchase. To determine an `offering_id`, see the `aws.rds.getReservedInstanceOffering` data source.
 * The following arguments are optional:
 * @property reservationId Customer-specified identifier to track this reservation.
 * @property tags Map of tags to assign to the DB reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ReservedInstanceArgs(
    public val instanceCount: Output<Int>? = null,
    public val offeringId: Output<String>? = null,
    public val reservationId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ReservedInstanceArgs> {
    override fun toJava(): com.pulumi.aws.rds.ReservedInstanceArgs =
        com.pulumi.aws.rds.ReservedInstanceArgs.builder()
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .offeringId(offeringId?.applyValue({ args0 -> args0 }))
            .reservationId(reservationId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReservedInstanceArgs].
 */
@PulumiTagMarker
public class ReservedInstanceArgsBuilder internal constructor() {
    private var instanceCount: Output<Int>? = null

    private var offeringId: Output<String>? = null

    private var reservationId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Number of instances to reserve. Default value is `1`.
     */
    @JvmName("vyayypdmrjmegwhr")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value ID of the Reserved DB instance offering to purchase. To determine an `offering_id`, see the `aws.rds.getReservedInstanceOffering` data source.
     * The following arguments are optional:
     */
    @JvmName("tygxslfpodtdutax")
    public suspend fun offeringId(`value`: Output<String>) {
        this.offeringId = value
    }

    /**
     * @param value Customer-specified identifier to track this reservation.
     */
    @JvmName("luycdfxsdexpmqwt")
    public suspend fun reservationId(`value`: Output<String>) {
        this.reservationId = value
    }

    /**
     * @param value Map of tags to assign to the DB reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("onpljdwtofervrxw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Number of instances to reserve. Default value is `1`.
     */
    @JvmName("nhwngchrxgheqbmi")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value ID of the Reserved DB instance offering to purchase. To determine an `offering_id`, see the `aws.rds.getReservedInstanceOffering` data source.
     * The following arguments are optional:
     */
    @JvmName("scbeglwkofklkuiq")
    public suspend fun offeringId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offeringId = mapped
    }

    /**
     * @param value Customer-specified identifier to track this reservation.
     */
    @JvmName("fvhnfhtjkdpjqyjd")
    public suspend fun reservationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservationId = mapped
    }

    /**
     * @param value Map of tags to assign to the DB reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iyabtyadfhrgoemj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the DB reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("petwccanmdtqknij")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReservedInstanceArgs = ReservedInstanceArgs(
        instanceCount = instanceCount,
        offeringId = offeringId,
        reservationId = reservationId,
        tags = tags,
    )
}
