@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RoleAssociation].
 */
@PulumiTagMarker
public class RoleAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleAssociationArgs = RoleAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleAssociationArgsBuilder.() -> Unit) {
        val builder = RoleAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RoleAssociation {
        val builtJavaResource = com.pulumi.aws.rds.RoleAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RoleAssociation(builtJavaResource)
    }
}

/**
 * Manages an RDS DB Instance association with an IAM Role. Example use cases:
 * * [Amazon RDS Oracle integration with Amazon S3](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html)
 * * [Importing Amazon S3 Data into an RDS PostgreSQL DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PostgreSQL.S3Import.html)
 * > To manage the RDS DB Instance IAM Role for [Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html), see the `aws.rds.Instance` resource `monitoring_role_arn` argument instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.RoleAssociation;
 * import com.pulumi.aws.rds.RoleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RoleAssociation("example", RoleAssociationArgs.builder()
 *             .dbInstanceIdentifier(aws_db_instance.example().identifier())
 *             .featureName("S3_INTEGRATION")
 *             .roleArn(aws_iam_role.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_db_instance_role_association` using the DB Instance Identifier and IAM Role ARN separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:rds/roleAssociation:RoleAssociation example my-db-instance,arn:aws:iam::123456789012:role/my-role
 * ```
 *
 */
public class RoleAssociation internal constructor(
    override val javaResource: com.pulumi.aws.rds.RoleAssociation,
) : KotlinCustomResource(javaResource, RoleAssociationMapper) {
    /**
     * DB Instance Identifier to associate with the IAM Role.
     */
    public val dbInstanceIdentifier: Output<String>
        get() = javaResource.dbInstanceIdentifier().applyValue({ args0 -> args0 })

    /**
     * Name of the feature for association. This can be found in the AWS documentation relevant to the integration or a full list is available in the `SupportedFeatureNames` list returned by [AWS CLI rds describe-db-engine-versions](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html).
     */
    public val featureName: Output<String>
        get() = javaResource.featureName().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the IAM Role to associate with the DB Instance.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })
}

public object RoleAssociationMapper : ResourceMapper<RoleAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.RoleAssociation::class == javaResource::class

    override fun map(javaResource: Resource): RoleAssociation = RoleAssociation(
        javaResource as
            com.pulumi.aws.rds.RoleAssociation,
    )
}

/**
 * @see [RoleAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoleAssociation].
 */
public suspend fun roleAssociation(
    name: String,
    block: suspend RoleAssociationResourceBuilder.() -> Unit,
): RoleAssociation {
    val builder = RoleAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoleAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun roleAssociation(name: String): RoleAssociation {
    val builder = RoleAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
