@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.RoleAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an RDS DB Instance association with an IAM Role. Example use cases:
 * * [Amazon RDS Oracle integration with Amazon S3](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html)
 * * [Importing Amazon S3 Data into an RDS PostgreSQL DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PostgreSQL.S3Import.html)
 * > To manage the RDS DB Instance IAM Role for [Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html), see the `aws.rds.Instance` resource `monitoring_role_arn` argument instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.RoleAssociation;
 * import com.pulumi.aws.rds.RoleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RoleAssociation("example", RoleAssociationArgs.builder()
 *             .dbInstanceIdentifier(aws_db_instance.example().identifier())
 *             .featureName("S3_INTEGRATION")
 *             .roleArn(aws_iam_role.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_db_instance_role_association` using the DB Instance Identifier and IAM Role ARN separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:rds/roleAssociation:RoleAssociation example my-db-instance,arn:aws:iam::123456789012:role/my-role
 * ```
 * @property dbInstanceIdentifier DB Instance Identifier to associate with the IAM Role.
 * @property featureName Name of the feature for association. This can be found in the AWS documentation relevant to the integration or a full list is available in the `SupportedFeatureNames` list returned by [AWS CLI rds describe-db-engine-versions](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html).
 * @property roleArn Amazon Resource Name (ARN) of the IAM Role to associate with the DB Instance.
 */
public data class RoleAssociationArgs(
    public val dbInstanceIdentifier: Output<String>? = null,
    public val featureName: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.RoleAssociationArgs> {
    override fun toJava(): com.pulumi.aws.rds.RoleAssociationArgs =
        com.pulumi.aws.rds.RoleAssociationArgs.builder()
            .dbInstanceIdentifier(dbInstanceIdentifier?.applyValue({ args0 -> args0 }))
            .featureName(featureName?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleAssociationArgs].
 */
@PulumiTagMarker
public class RoleAssociationArgsBuilder internal constructor() {
    private var dbInstanceIdentifier: Output<String>? = null

    private var featureName: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value DB Instance Identifier to associate with the IAM Role.
     */
    @JvmName("xwvwqiybnshisdhr")
    public suspend fun dbInstanceIdentifier(`value`: Output<String>) {
        this.dbInstanceIdentifier = value
    }

    /**
     * @param value Name of the feature for association. This can be found in the AWS documentation relevant to the integration or a full list is available in the `SupportedFeatureNames` list returned by [AWS CLI rds describe-db-engine-versions](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("dkkrutcvhpftwvaf")
    public suspend fun featureName(`value`: Output<String>) {
        this.featureName = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role to associate with the DB Instance.
     */
    @JvmName("gggtcqksjfowavwj")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value DB Instance Identifier to associate with the IAM Role.
     */
    @JvmName("lokahjhjdvybfvdn")
    public suspend fun dbInstanceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIdentifier = mapped
    }

    /**
     * @param value Name of the feature for association. This can be found in the AWS documentation relevant to the integration or a full list is available in the `SupportedFeatureNames` list returned by [AWS CLI rds describe-db-engine-versions](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("hsxgbvgeqtomkxyr")
    public suspend fun featureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureName = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role to associate with the DB Instance.
     */
    @JvmName("ikynspefmcxbyuuf")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): RoleAssociationArgs = RoleAssociationArgs(
        dbInstanceIdentifier = dbInstanceIdentifier,
        featureName = featureName,
        roleArn = roleArn,
    )
}
