@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Snapshot].
 */
@PulumiTagMarker
public class SnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotArgs = SnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotArgsBuilder.() -> Unit) {
        val builder = SnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Snapshot {
        val builtJavaResource = com.pulumi.aws.rds.Snapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Snapshot(builtJavaResource)
    }
}

/**
 * Manages an RDS database instance snapshot. For managing RDS database cluster snapshots, see the `aws.rds.ClusterSnapshot` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.rds.Snapshot;
 * import com.pulumi.aws.rds.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Instance("bar", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .engine("mysql")
 *             .engineVersion("5.6.21")
 *             .instanceClass("db.t2.micro")
 *             .dbName("baz")
 *             .password("barbarbarbar")
 *             .username("foo")
 *             .maintenanceWindow("Fri:09:00-Fri:09:30")
 *             .backupRetentionPeriod(0)
 *             .parameterGroupName("default.mysql5.6")
 *             .build());
 *         var test = new Snapshot("test", SnapshotArgs.builder()
 *             .dbInstanceIdentifier(bar.identifier())
 *             .dbSnapshotIdentifier("testsnapshot1234")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_db_snapshot` using the snapshot identifier. For example:
 * ```sh
 *  $ pulumi import aws:rds/snapshot:Snapshot example my-snapshot
 * ```
 *
 */
public class Snapshot internal constructor(
    override val javaResource: com.pulumi.aws.rds.Snapshot,
) : KotlinCustomResource(javaResource, SnapshotMapper) {
    /**
     * Specifies the allocated storage size in gigabytes (GB).
     */
    public val allocatedStorage: Output<Int>
        get() = javaResource.allocatedStorage().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The DB Instance Identifier from which to take the snapshot.
     */
    public val dbInstanceIdentifier: Output<String>
        get() = javaResource.dbInstanceIdentifier().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the DB snapshot.
     */
    public val dbSnapshotArn: Output<String>
        get() = javaResource.dbSnapshotArn().applyValue({ args0 -> args0 })

    /**
     * The Identifier for the snapshot.
     */
    public val dbSnapshotIdentifier: Output<String>
        get() = javaResource.dbSnapshotIdentifier().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the DB snapshot is encrypted.
     */
    public val encrypted: Output<Boolean>
        get() = javaResource.encrypted().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the database engine.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * Specifies the version of the database engine.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
     */
    public val iops: Output<Int>
        get() = javaResource.iops().applyValue({ args0 -> args0 })

    /**
     * The ARN for the KMS encryption key.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * License model information for the restored DB instance.
     */
    public val licenseModel: Output<String>
        get() = javaResource.licenseModel().applyValue({ args0 -> args0 })

    /**
     * Provides the option group name for the DB snapshot.
     */
    public val optionGroupName: Output<String>
        get() = javaResource.optionGroupName().applyValue({ args0 -> args0 })

    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    public val sharedAccounts: Output<List<String>>?
        get() = javaResource.sharedAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val snapshotType: Output<String>
        get() = javaResource.snapshotType().applyValue({ args0 -> args0 })

    /**
     * The DB snapshot Arn that the DB snapshot was copied from. It only has value in case of cross customer or cross region copy.
     */
    public val sourceDbSnapshotIdentifier: Output<String>
        get() = javaResource.sourceDbSnapshotIdentifier().applyValue({ args0 -> args0 })

    /**
     * The region that the DB snapshot was created in or copied from.
     */
    public val sourceRegion: Output<String>
        get() = javaResource.sourceRegion().applyValue({ args0 -> args0 })

    /**
     * Specifies the status of this DB snapshot.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Specifies the storage type associated with DB snapshot.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Provides the VPC ID associated with the DB snapshot.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object SnapshotMapper : ResourceMapper<Snapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.Snapshot::class == javaResource::class

    override fun map(javaResource: Resource): Snapshot = Snapshot(
        javaResource as
            com.pulumi.aws.rds.Snapshot,
    )
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Snapshot].
 */
public suspend fun snapshot(name: String, block: suspend SnapshotResourceBuilder.() -> Unit):
    Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshot(name: String): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
