@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.SnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an RDS database instance snapshot. For managing RDS database cluster snapshots, see the `aws.rds.ClusterSnapshot` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.rds.Snapshot;
 * import com.pulumi.aws.rds.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Instance("bar", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .engine("mysql")
 *             .engineVersion("5.6.21")
 *             .instanceClass("db.t2.micro")
 *             .dbName("baz")
 *             .password("barbarbarbar")
 *             .username("foo")
 *             .maintenanceWindow("Fri:09:00-Fri:09:30")
 *             .backupRetentionPeriod(0)
 *             .parameterGroupName("default.mysql5.6")
 *             .build());
 *         var test = new Snapshot("test", SnapshotArgs.builder()
 *             .dbInstanceIdentifier(bar.identifier())
 *             .dbSnapshotIdentifier("testsnapshot1234")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_db_snapshot` using the snapshot identifier. For example:
 * ```sh
 *  $ pulumi import aws:rds/snapshot:Snapshot example my-snapshot
 * ```
 * @property dbInstanceIdentifier The DB Instance Identifier from which to take the snapshot.
 * @property dbSnapshotIdentifier The Identifier for the snapshot.
 * @property sharedAccounts List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SnapshotArgs(
    public val dbInstanceIdentifier: Output<String>? = null,
    public val dbSnapshotIdentifier: Output<String>? = null,
    public val sharedAccounts: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.SnapshotArgs> {
    override fun toJava(): com.pulumi.aws.rds.SnapshotArgs = com.pulumi.aws.rds.SnapshotArgs.builder()
        .dbInstanceIdentifier(dbInstanceIdentifier?.applyValue({ args0 -> args0 }))
        .dbSnapshotIdentifier(dbSnapshotIdentifier?.applyValue({ args0 -> args0 }))
        .sharedAccounts(sharedAccounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [SnapshotArgs].
 */
@PulumiTagMarker
public class SnapshotArgsBuilder internal constructor() {
    private var dbInstanceIdentifier: Output<String>? = null

    private var dbSnapshotIdentifier: Output<String>? = null

    private var sharedAccounts: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The DB Instance Identifier from which to take the snapshot.
     */
    @JvmName("tquvskaqtrmxrfji")
    public suspend fun dbInstanceIdentifier(`value`: Output<String>) {
        this.dbInstanceIdentifier = value
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("ioeuypwyxwxhqhpp")
    public suspend fun dbSnapshotIdentifier(`value`: Output<String>) {
        this.dbSnapshotIdentifier = value
    }

    /**
     * @param value List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("cngwkpfcjdkrjudf")
    public suspend fun sharedAccounts(`value`: Output<List<String>>) {
        this.sharedAccounts = value
    }

    @JvmName("nyuvpbekaebxfdyf")
    public suspend fun sharedAccounts(vararg values: Output<String>) {
        this.sharedAccounts = Output.all(values.asList())
    }

    /**
     * @param values List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("kwdlgxnvxnloxykx")
    public suspend fun sharedAccounts(values: List<Output<String>>) {
        this.sharedAccounts = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wihyjgxlguuqqbcw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The DB Instance Identifier from which to take the snapshot.
     */
    @JvmName("glcljugcjkuibuvk")
    public suspend fun dbInstanceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIdentifier = mapped
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("khbttdfjhuxgoghv")
    public suspend fun dbSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbSnapshotIdentifier = mapped
    }

    /**
     * @param value List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("beiddrminoykmvxr")
    public suspend fun sharedAccounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccounts = mapped
    }

    /**
     * @param values List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("kmsqtafkfyfcmuhb")
    public suspend fun sharedAccounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sharedAccounts = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hkxhsdrlnahcjrtc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iuvhqijpdskeqqhk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SnapshotArgs = SnapshotArgs(
        dbInstanceIdentifier = dbInstanceIdentifier,
        dbSnapshotIdentifier = dbSnapshotIdentifier,
        sharedAccounts = sharedAccounts,
        tags = tags,
    )
}
