@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.SnapshotCopyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an RDS database instance snapshot copy. For managing RDS database cluster snapshots, see the `aws.rds.ClusterSnapshot` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.rds.Snapshot;
 * import com.pulumi.aws.rds.SnapshotArgs;
 * import com.pulumi.aws.rds.SnapshotCopy;
 * import com.pulumi.aws.rds.SnapshotCopyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .engine("mysql")
 *             .engineVersion("5.6.21")
 *             .instanceClass("db.t2.micro")
 *             .dbName("baz")
 *             .password("barbarbarbar")
 *             .username("foo")
 *             .maintenanceWindow("Fri:09:00-Fri:09:30")
 *             .backupRetentionPeriod(0)
 *             .parameterGroupName("default.mysql5.6")
 *             .build());
 *         var exampleSnapshot = new Snapshot("exampleSnapshot", SnapshotArgs.builder()
 *             .dbInstanceIdentifier(exampleInstance.identifier())
 *             .dbSnapshotIdentifier("testsnapshot1234")
 *             .build());
 *         var exampleSnapshotCopy = new SnapshotCopy("exampleSnapshotCopy", SnapshotCopyArgs.builder()
 *             .sourceDbSnapshotIdentifier(exampleSnapshot.dbSnapshotArn())
 *             .targetDbSnapshotIdentifier("testsnapshot1234-copy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_db_snapshot_copy` using the snapshot identifier. For example:
 * ```sh
 *  $ pulumi import aws:rds/snapshotCopy:SnapshotCopy example my-snapshot
 * ```
 * @property copyTags Whether to copy existing tags. Defaults to `false`.
 * @property destinationRegion The Destination region to place snapshot copy.
 * @property kmsKeyId KMS key ID.
 * @property optionGroupName The name of an option group to associate with the copy of the snapshot.
 * @property presignedUrl he URL that contains a Signature Version 4 signed request.
 * @property sourceDbSnapshotIdentifier Snapshot identifier of the source snapshot.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetCustomAvailabilityZone The external custom Availability Zone.
 * @property targetDbSnapshotIdentifier The Identifier for the snapshot.
 */
public data class SnapshotCopyArgs(
    public val copyTags: Output<Boolean>? = null,
    public val destinationRegion: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val optionGroupName: Output<String>? = null,
    public val presignedUrl: Output<String>? = null,
    public val sourceDbSnapshotIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetCustomAvailabilityZone: Output<String>? = null,
    public val targetDbSnapshotIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.SnapshotCopyArgs> {
    override fun toJava(): com.pulumi.aws.rds.SnapshotCopyArgs =
        com.pulumi.aws.rds.SnapshotCopyArgs.builder()
            .copyTags(copyTags?.applyValue({ args0 -> args0 }))
            .destinationRegion(destinationRegion?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .optionGroupName(optionGroupName?.applyValue({ args0 -> args0 }))
            .presignedUrl(presignedUrl?.applyValue({ args0 -> args0 }))
            .sourceDbSnapshotIdentifier(sourceDbSnapshotIdentifier?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetCustomAvailabilityZone(targetCustomAvailabilityZone?.applyValue({ args0 -> args0 }))
            .targetDbSnapshotIdentifier(targetDbSnapshotIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotCopyArgs].
 */
@PulumiTagMarker
public class SnapshotCopyArgsBuilder internal constructor() {
    private var copyTags: Output<Boolean>? = null

    private var destinationRegion: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var optionGroupName: Output<String>? = null

    private var presignedUrl: Output<String>? = null

    private var sourceDbSnapshotIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetCustomAvailabilityZone: Output<String>? = null

    private var targetDbSnapshotIdentifier: Output<String>? = null

    /**
     * @param value Whether to copy existing tags. Defaults to `false`.
     */
    @JvmName("cpcgpltbjjctycjw")
    public suspend fun copyTags(`value`: Output<Boolean>) {
        this.copyTags = value
    }

    /**
     * @param value The Destination region to place snapshot copy.
     */
    @JvmName("uvjosssrsjqsdtkr")
    public suspend fun destinationRegion(`value`: Output<String>) {
        this.destinationRegion = value
    }

    /**
     * @param value KMS key ID.
     */
    @JvmName("utycstgjjqlyvabq")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The name of an option group to associate with the copy of the snapshot.
     */
    @JvmName("xvhxgpvprkktjkkm")
    public suspend fun optionGroupName(`value`: Output<String>) {
        this.optionGroupName = value
    }

    /**
     * @param value he URL that contains a Signature Version 4 signed request.
     */
    @JvmName("uoyrmewmmrkqentj")
    public suspend fun presignedUrl(`value`: Output<String>) {
        this.presignedUrl = value
    }

    /**
     * @param value Snapshot identifier of the source snapshot.
     */
    @JvmName("baqstwgukavlmlge")
    public suspend fun sourceDbSnapshotIdentifier(`value`: Output<String>) {
        this.sourceDbSnapshotIdentifier = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rrqqutoetilntipw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The external custom Availability Zone.
     */
    @JvmName("tmeyohlmligitxdm")
    public suspend fun targetCustomAvailabilityZone(`value`: Output<String>) {
        this.targetCustomAvailabilityZone = value
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("hqqcpqjgpemtfftl")
    public suspend fun targetDbSnapshotIdentifier(`value`: Output<String>) {
        this.targetDbSnapshotIdentifier = value
    }

    /**
     * @param value Whether to copy existing tags. Defaults to `false`.
     */
    @JvmName("qedkosxtivsoqcws")
    public suspend fun copyTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTags = mapped
    }

    /**
     * @param value The Destination region to place snapshot copy.
     */
    @JvmName("lnoowbrhhxfxptxa")
    public suspend fun destinationRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationRegion = mapped
    }

    /**
     * @param value KMS key ID.
     */
    @JvmName("rraujbhovqsiilbs")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The name of an option group to associate with the copy of the snapshot.
     */
    @JvmName("bwwfyiosqdngsaxv")
    public suspend fun optionGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionGroupName = mapped
    }

    /**
     * @param value he URL that contains a Signature Version 4 signed request.
     */
    @JvmName("veqdoravuqcjkiyu")
    public suspend fun presignedUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presignedUrl = mapped
    }

    /**
     * @param value Snapshot identifier of the source snapshot.
     */
    @JvmName("lejmgvdcbmfcyaqv")
    public suspend fun sourceDbSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbSnapshotIdentifier = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ckdnpnjxrdxhnvjc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vmcivqjrerpcffwm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The external custom Availability Zone.
     */
    @JvmName("qkgsykorpngfvmfc")
    public suspend fun targetCustomAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCustomAvailabilityZone = mapped
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("jjwiuqagjwuaqjdp")
    public suspend fun targetDbSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDbSnapshotIdentifier = mapped
    }

    internal fun build(): SnapshotCopyArgs = SnapshotCopyArgs(
        copyTags = copyTags,
        destinationRegion = destinationRegion,
        kmsKeyId = kmsKeyId,
        optionGroupName = optionGroupName,
        presignedUrl = presignedUrl,
        sourceDbSnapshotIdentifier = sourceDbSnapshotIdentifier,
        tags = tags,
        targetCustomAvailabilityZone = targetCustomAvailabilityZone,
        targetDbSnapshotIdentifier = targetDbSnapshotIdentifier,
    )
}
