@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.ClusterRestoreToPointInTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property restoreToTime Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
 * @property restoreType Type of restore to be performed.
 * Valid options are `full-copy` (default) and `copy-on-write`.
 * @property sourceClusterIdentifier Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
 * @property useLatestRestorableTime Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
 */
public data class ClusterRestoreToPointInTimeArgs(
    public val restoreToTime: Output<String>? = null,
    public val restoreType: Output<String>? = null,
    public val sourceClusterIdentifier: Output<String>,
    public val useLatestRestorableTime: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.ClusterRestoreToPointInTimeArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.ClusterRestoreToPointInTimeArgs =
        com.pulumi.aws.rds.inputs.ClusterRestoreToPointInTimeArgs.builder()
            .restoreToTime(restoreToTime?.applyValue({ args0 -> args0 }))
            .restoreType(restoreType?.applyValue({ args0 -> args0 }))
            .sourceClusterIdentifier(sourceClusterIdentifier.applyValue({ args0 -> args0 }))
            .useLatestRestorableTime(useLatestRestorableTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterRestoreToPointInTimeArgs].
 */
@PulumiTagMarker
public class ClusterRestoreToPointInTimeArgsBuilder internal constructor() {
    private var restoreToTime: Output<String>? = null

    private var restoreType: Output<String>? = null

    private var sourceClusterIdentifier: Output<String>? = null

    private var useLatestRestorableTime: Output<Boolean>? = null

    /**
     * @param value Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
     */
    @JvmName("aojkbdpaksqvxklx")
    public suspend fun restoreToTime(`value`: Output<String>) {
        this.restoreToTime = value
    }

    /**
     * @param value Type of restore to be performed.
     * Valid options are `full-copy` (default) and `copy-on-write`.
     */
    @JvmName("iveuslexxtlqfdgr")
    public suspend fun restoreType(`value`: Output<String>) {
        this.restoreType = value
    }

    /**
     * @param value Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
     */
    @JvmName("wybhyogtkgmoiytj")
    public suspend fun sourceClusterIdentifier(`value`: Output<String>) {
        this.sourceClusterIdentifier = value
    }

    /**
     * @param value Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
     */
    @JvmName("ofquvrkfiydnoauj")
    public suspend fun useLatestRestorableTime(`value`: Output<Boolean>) {
        this.useLatestRestorableTime = value
    }

    /**
     * @param value Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
     */
    @JvmName("okpitxaemhgxoubp")
    public suspend fun restoreToTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreToTime = mapped
    }

    /**
     * @param value Type of restore to be performed.
     * Valid options are `full-copy` (default) and `copy-on-write`.
     */
    @JvmName("kejltaekbaviejyw")
    public suspend fun restoreType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreType = mapped
    }

    /**
     * @param value Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
     */
    @JvmName("hgwmpfmssteuclty")
    public suspend fun sourceClusterIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceClusterIdentifier = mapped
    }

    /**
     * @param value Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
     */
    @JvmName("nxsksjgqswqipotk")
    public suspend fun useLatestRestorableTime(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useLatestRestorableTime = mapped
    }

    internal fun build(): ClusterRestoreToPointInTimeArgs = ClusterRestoreToPointInTimeArgs(
        restoreToTime = restoreToTime,
        restoreType = restoreType,
        sourceClusterIdentifier = sourceClusterIdentifier ?: throw
            PulumiNullFieldException("sourceClusterIdentifier"),
        useLatestRestorableTime = useLatestRestorableTime,
    )
}
