@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.ClusterS3ImportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName Bucket name where your backup is stored
 * @property bucketPrefix Can be blank, but is the path to your backup
 * @property ingestionRole Role applied to load the data.
 * @property sourceEngine Source engine for the backup
 * @property sourceEngineVersion Version of the source engine used to make the backup
 * This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
 */
public data class ClusterS3ImportArgs(
    public val bucketName: Output<String>,
    public val bucketPrefix: Output<String>? = null,
    public val ingestionRole: Output<String>,
    public val sourceEngine: Output<String>,
    public val sourceEngineVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.ClusterS3ImportArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.ClusterS3ImportArgs =
        com.pulumi.aws.rds.inputs.ClusterS3ImportArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .ingestionRole(ingestionRole.applyValue({ args0 -> args0 }))
            .sourceEngine(sourceEngine.applyValue({ args0 -> args0 }))
            .sourceEngineVersion(sourceEngineVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterS3ImportArgs].
 */
@PulumiTagMarker
public class ClusterS3ImportArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var ingestionRole: Output<String>? = null

    private var sourceEngine: Output<String>? = null

    private var sourceEngineVersion: Output<String>? = null

    /**
     * @param value Bucket name where your backup is stored
     */
    @JvmName("rvegnylqyjoiuycf")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Can be blank, but is the path to your backup
     */
    @JvmName("dfwuvddsofarshwv")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value Role applied to load the data.
     */
    @JvmName("nhuqgspcbsdumwiu")
    public suspend fun ingestionRole(`value`: Output<String>) {
        this.ingestionRole = value
    }

    /**
     * @param value Source engine for the backup
     */
    @JvmName("vbakrnxvndpvnbct")
    public suspend fun sourceEngine(`value`: Output<String>) {
        this.sourceEngine = value
    }

    /**
     * @param value Version of the source engine used to make the backup
     * This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
     */
    @JvmName("vajgnkagdtnmlbrq")
    public suspend fun sourceEngineVersion(`value`: Output<String>) {
        this.sourceEngineVersion = value
    }

    /**
     * @param value Bucket name where your backup is stored
     */
    @JvmName("iupmnjsascapsgmh")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Can be blank, but is the path to your backup
     */
    @JvmName("bximpfkdxiloyhii")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value Role applied to load the data.
     */
    @JvmName("pmhdnvlwagktbqky")
    public suspend fun ingestionRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionRole = mapped
    }

    /**
     * @param value Source engine for the backup
     */
    @JvmName("mpdinkuursnvnebm")
    public suspend fun sourceEngine(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceEngine = mapped
    }

    /**
     * @param value Version of the source engine used to make the backup
     * This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
     */
    @JvmName("bcirtflrnrybqaja")
    public suspend fun sourceEngineVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceEngineVersion = mapped
    }

    internal fun build(): ClusterS3ImportArgs = ClusterS3ImportArgs(
        bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        bucketPrefix = bucketPrefix,
        ingestionRole = ingestionRole ?: throw PulumiNullFieldException("ingestionRole"),
        sourceEngine = sourceEngine ?: throw PulumiNullFieldException("sourceEngine"),
        sourceEngineVersion = sourceEngineVersion ?: throw PulumiNullFieldException("sourceEngineVersion"),
    )
}
