@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.ClusterServerlessv2ScalingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxCapacity Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
 * @property minCapacity Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
 */
public data class ClusterServerlessv2ScalingConfigurationArgs(
    public val maxCapacity: Output<Double>,
    public val minCapacity: Output<Double>,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.ClusterServerlessv2ScalingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.ClusterServerlessv2ScalingConfigurationArgs =
        com.pulumi.aws.rds.inputs.ClusterServerlessv2ScalingConfigurationArgs.builder()
            .maxCapacity(maxCapacity.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterServerlessv2ScalingConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterServerlessv2ScalingConfigurationArgsBuilder internal constructor() {
    private var maxCapacity: Output<Double>? = null

    private var minCapacity: Output<Double>? = null

    /**
     * @param value Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
     */
    @JvmName("hgltgbdxilqhicfa")
    public suspend fun maxCapacity(`value`: Output<Double>) {
        this.maxCapacity = value
    }

    /**
     * @param value Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
     */
    @JvmName("bpbkwtajjvdjpkoi")
    public suspend fun minCapacity(`value`: Output<Double>) {
        this.minCapacity = value
    }

    /**
     * @param value Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
     */
    @JvmName("kodrghhghblkcoup")
    public suspend fun maxCapacity(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
     */
    @JvmName("undsmthdjlobjnlh")
    public suspend fun minCapacity(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    internal fun build(): ClusterServerlessv2ScalingConfigurationArgs =
        ClusterServerlessv2ScalingConfigurationArgs(
            maxCapacity = maxCapacity ?: throw PulumiNullFieldException("maxCapacity"),
            minCapacity = minCapacity ?: throw PulumiNullFieldException("minCapacity"),
        )
}
