@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.ExportTaskTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create
 * @property delete
 */
public data class ExportTaskTimeoutsArgs(
    public val create: Output<String>? = null,
    public val delete: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.ExportTaskTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.ExportTaskTimeoutsArgs =
        com.pulumi.aws.rds.inputs.ExportTaskTimeoutsArgs.builder()
            .create(create?.applyValue({ args0 -> args0 }))
            .delete(delete?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportTaskTimeoutsArgs].
 */
@PulumiTagMarker
public class ExportTaskTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    private var delete: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("muamkrugrfgvcpvx")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value
     */
    @JvmName("iibjkqmurpinewhk")
    public suspend fun delete(`value`: Output<String>) {
        this.delete = value
    }

    /**
     * @param value
     */
    @JvmName("aabubodvjxrolulb")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    /**
     * @param value
     */
    @JvmName("bnscralxhnjaeoko")
    public suspend fun delete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    internal fun build(): ExportTaskTimeoutsArgs = ExportTaskTimeoutsArgs(
        create = create,
        delete = delete,
    )
}
