@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetClustersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusters.
 * @property filters Configuration block(s) for filtering. Detailed below.
 */
public data class GetClustersPlainArgs(
    public val filters: List<GetClustersFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetClustersPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetClustersPlainArgs =
        com.pulumi.aws.rds.inputs.GetClustersPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetClustersPlainArgs].
 */
@PulumiTagMarker
public class GetClustersPlainArgsBuilder internal constructor() {
    private var filters: List<GetClustersFilter>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("sofyhwmoqkvyvcof")
    public suspend fun filters(`value`: List<GetClustersFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("qhwkfsrujyskgmwf")
    public suspend fun filters(argument: List<suspend GetClustersFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetClustersFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("kbrbotdwdqsciabm")
    public suspend fun filters(vararg argument: suspend GetClustersFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetClustersFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("rtojhcgrdeqapttl")
    public suspend fun filters(argument: suspend GetClustersFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetClustersFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("xmgowhutpmjeivuw")
    public suspend fun filters(vararg values: GetClustersFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetClustersPlainArgs = GetClustersPlainArgs(
        filters = filters,
    )
}
