@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetEngineVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEngineVersion.
 * @property defaultOnly When set to `true`, the default version for the specified `engine` or combination of `engine` and major `version` will be returned. Can be used to limit responses to a single version when they would otherwise fail for returning multiple versions.
 * @property engine DB engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
 * @property filters One or more name/value pairs to filter off of. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
 * @property includeAll When set to `true`, the specified `version` or member of `preferred_versions` will be returned even if it is `deprecated`. Otherwise, only `available` versions will be returned.
 * @property parameterGroupFamily Name of a specific DB parameter group family. Examples of parameter group families are `mysql8.0`, `mariadb10.4`, and `postgres12`.
 * @property preferredVersions Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
 * @property version Version of the DB engine. For example, `5.7.22`, `10.1.34`, and `12.3`. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
 */
public data class GetEngineVersionPlainArgs(
    public val defaultOnly: Boolean? = null,
    public val engine: String,
    public val filters: List<GetEngineVersionFilter>? = null,
    public val includeAll: Boolean? = null,
    public val parameterGroupFamily: String? = null,
    public val preferredVersions: List<String>? = null,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetEngineVersionPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetEngineVersionPlainArgs =
        com.pulumi.aws.rds.inputs.GetEngineVersionPlainArgs.builder()
            .defaultOnly(defaultOnly?.let({ args0 -> args0 }))
            .engine(engine.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .includeAll(includeAll?.let({ args0 -> args0 }))
            .parameterGroupFamily(parameterGroupFamily?.let({ args0 -> args0 }))
            .preferredVersions(preferredVersions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEngineVersionPlainArgs].
 */
@PulumiTagMarker
public class GetEngineVersionPlainArgsBuilder internal constructor() {
    private var defaultOnly: Boolean? = null

    private var engine: String? = null

    private var filters: List<GetEngineVersionFilter>? = null

    private var includeAll: Boolean? = null

    private var parameterGroupFamily: String? = null

    private var preferredVersions: List<String>? = null

    private var version: String? = null

    /**
     * @param value When set to `true`, the default version for the specified `engine` or combination of `engine` and major `version` will be returned. Can be used to limit responses to a single version when they would otherwise fail for returning multiple versions.
     */
    @JvmName("ifumgysixjgdgfkj")
    public suspend fun defaultOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.defaultOnly = mapped
    }

    /**
     * @param value DB engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
     */
    @JvmName("iomagmcelabkxpmf")
    public suspend fun engine(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value One or more name/value pairs to filter off of. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("tgxlocrcpwgremqr")
    public suspend fun filters(`value`: List<GetEngineVersionFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("aedpxmsyqcolskhh")
    public suspend fun filters(argument: List<suspend GetEngineVersionFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetEngineVersionFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("gsxfhwfuafaouiqw")
    public suspend fun filters(vararg argument: suspend GetEngineVersionFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetEngineVersionFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("wwcyecypjjiqflur")
    public suspend fun filters(argument: suspend GetEngineVersionFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetEngineVersionFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to filter off of. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("kqxlwryjgfnondff")
    public suspend fun filters(vararg values: GetEngineVersionFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value When set to `true`, the specified `version` or member of `preferred_versions` will be returned even if it is `deprecated`. Otherwise, only `available` versions will be returned.
     */
    @JvmName("njpayolvpribidgx")
    public suspend fun includeAll(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeAll = mapped
    }

    /**
     * @param value Name of a specific DB parameter group family. Examples of parameter group families are `mysql8.0`, `mariadb10.4`, and `postgres12`.
     */
    @JvmName("xpmmecaydmnuiaga")
    public suspend fun parameterGroupFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parameterGroupFamily = mapped
    }

    /**
     * @param value Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     */
    @JvmName("wqgslumneamyagfk")
    public suspend fun preferredVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredVersions = mapped
    }

    /**
     * @param values Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     */
    @JvmName("iivgcfflyhreltet")
    public suspend fun preferredVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredVersions = mapped
    }

    /**
     * @param value Version of the DB engine. For example, `5.7.22`, `10.1.34`, and `12.3`. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     */
    @JvmName("ksrebraqrhstgyec")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetEngineVersionPlainArgs = GetEngineVersionPlainArgs(
        defaultOnly = defaultOnly,
        engine = engine ?: throw PulumiNullFieldException("engine"),
        filters = filters,
        includeAll = includeAll,
        parameterGroupFamily = parameterGroupFamily,
        preferredVersions = preferredVersions,
        version = version,
    )
}
