@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetEventCategoriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEventCategories.
 * @property sourceType Type of source that will be generating the events. Valid options are db-instance, db-security-group, db-parameter-group, db-snapshot, db-cluster or db-cluster-snapshot.
 */
public data class GetEventCategoriesPlainArgs(
    public val sourceType: String? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetEventCategoriesPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetEventCategoriesPlainArgs =
        com.pulumi.aws.rds.inputs.GetEventCategoriesPlainArgs.builder()
            .sourceType(sourceType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEventCategoriesPlainArgs].
 */
@PulumiTagMarker
public class GetEventCategoriesPlainArgsBuilder internal constructor() {
    private var sourceType: String? = null

    /**
     * @param value Type of source that will be generating the events. Valid options are db-instance, db-security-group, db-parameter-group, db-snapshot, db-cluster or db-cluster-snapshot.
     */
    @JvmName("hrnllroaqbewexqi")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceType = mapped
    }

    internal fun build(): GetEventCategoriesPlainArgs = GetEventCategoriesPlainArgs(
        sourceType = sourceType,
    )
}
