@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetOrderableDbInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOrderableDbInstance.
 * @property availabilityZoneGroup Availability zone group.
 * @property engine DB engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
 * @property engineVersion Version of the DB engine. If none is provided, the AWS-defined default version will be used.
 * @property instanceClass DB instance class. Examples of classes are `db.m3.2xlarge`, `db.t2.small`, and `db.m3.medium`.
 * @property licenseModel License model. Examples of license models are `general-public-license`, `bring-your-own-license`, and `amazon-license`.
 * @property preferredEngineVersions Ordered list of preferred RDS DB instance engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
 * @property preferredInstanceClasses Ordered list of preferred RDS DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
 * @property storageType Storage types. Examples of storage types are `standard`, `io1`, `gp2`, and `aurora`.
 * @property supportsEnhancedMonitoring Enable this to ensure a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
 * @property supportsGlobalDatabases Enable this to ensure a DB instance supports Aurora global databases with a specific combination of other DB engine attributes.
 * @property supportsIamDatabaseAuthentication Enable this to ensure a DB instance supports IAM database authentication.
 * @property supportsIops Enable this to ensure a DB instance supports provisioned IOPS.
 * @property supportsKerberosAuthentication Enable this to ensure a DB instance supports Kerberos Authentication.
 * @property supportsPerformanceInsights Enable this to ensure a DB instance supports Performance Insights.
 * @property supportsStorageAutoscaling Enable this to ensure Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
 * @property supportsStorageEncryption Enable this to ensure a DB instance supports encrypted storage.
 * @property vpc Boolean that indicates whether to show only VPC or non-VPC offerings.
 */
public data class GetOrderableDbInstancePlainArgs(
    public val availabilityZoneGroup: String? = null,
    public val engine: String,
    public val engineVersion: String? = null,
    public val instanceClass: String? = null,
    public val licenseModel: String? = null,
    public val preferredEngineVersions: List<String>? = null,
    public val preferredInstanceClasses: List<String>? = null,
    public val storageType: String? = null,
    public val supportsEnhancedMonitoring: Boolean? = null,
    public val supportsGlobalDatabases: Boolean? = null,
    public val supportsIamDatabaseAuthentication: Boolean? = null,
    public val supportsIops: Boolean? = null,
    public val supportsKerberosAuthentication: Boolean? = null,
    public val supportsPerformanceInsights: Boolean? = null,
    public val supportsStorageAutoscaling: Boolean? = null,
    public val supportsStorageEncryption: Boolean? = null,
    public val vpc: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetOrderableDbInstancePlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetOrderableDbInstancePlainArgs =
        com.pulumi.aws.rds.inputs.GetOrderableDbInstancePlainArgs.builder()
            .availabilityZoneGroup(availabilityZoneGroup?.let({ args0 -> args0 }))
            .engine(engine.let({ args0 -> args0 }))
            .engineVersion(engineVersion?.let({ args0 -> args0 }))
            .instanceClass(instanceClass?.let({ args0 -> args0 }))
            .licenseModel(licenseModel?.let({ args0 -> args0 }))
            .preferredEngineVersions(preferredEngineVersions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .preferredInstanceClasses(preferredInstanceClasses?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageType(storageType?.let({ args0 -> args0 }))
            .supportsEnhancedMonitoring(supportsEnhancedMonitoring?.let({ args0 -> args0 }))
            .supportsGlobalDatabases(supportsGlobalDatabases?.let({ args0 -> args0 }))
            .supportsIamDatabaseAuthentication(supportsIamDatabaseAuthentication?.let({ args0 -> args0 }))
            .supportsIops(supportsIops?.let({ args0 -> args0 }))
            .supportsKerberosAuthentication(supportsKerberosAuthentication?.let({ args0 -> args0 }))
            .supportsPerformanceInsights(supportsPerformanceInsights?.let({ args0 -> args0 }))
            .supportsStorageAutoscaling(supportsStorageAutoscaling?.let({ args0 -> args0 }))
            .supportsStorageEncryption(supportsStorageEncryption?.let({ args0 -> args0 }))
            .vpc(vpc?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrderableDbInstancePlainArgs].
 */
@PulumiTagMarker
public class GetOrderableDbInstancePlainArgsBuilder internal constructor() {
    private var availabilityZoneGroup: String? = null

    private var engine: String? = null

    private var engineVersion: String? = null

    private var instanceClass: String? = null

    private var licenseModel: String? = null

    private var preferredEngineVersions: List<String>? = null

    private var preferredInstanceClasses: List<String>? = null

    private var storageType: String? = null

    private var supportsEnhancedMonitoring: Boolean? = null

    private var supportsGlobalDatabases: Boolean? = null

    private var supportsIamDatabaseAuthentication: Boolean? = null

    private var supportsIops: Boolean? = null

    private var supportsKerberosAuthentication: Boolean? = null

    private var supportsPerformanceInsights: Boolean? = null

    private var supportsStorageAutoscaling: Boolean? = null

    private var supportsStorageEncryption: Boolean? = null

    private var vpc: Boolean? = null

    /**
     * @param value Availability zone group.
     */
    @JvmName("clrnajxubpqtgmuc")
    public suspend fun availabilityZoneGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZoneGroup = mapped
    }

    /**
     * @param value DB engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
     */
    @JvmName("oidcygoelnyxbwgg")
    public suspend fun engine(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Version of the DB engine. If none is provided, the AWS-defined default version will be used.
     */
    @JvmName("wtlhuqrjefanqnsv")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    /**
     * @param value DB instance class. Examples of classes are `db.m3.2xlarge`, `db.t2.small`, and `db.m3.medium`.
     */
    @JvmName("chxpneqytiudaccb")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceClass = mapped
    }

    /**
     * @param value License model. Examples of license models are `general-public-license`, `bring-your-own-license`, and `amazon-license`.
     */
    @JvmName("xpbyicbywohtajen")
    public suspend fun licenseModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.licenseModel = mapped
    }

    /**
     * @param value Ordered list of preferred RDS DB instance engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     */
    @JvmName("klfasclcucyhqwrt")
    public suspend fun preferredEngineVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredEngineVersions = mapped
    }

    /**
     * @param values Ordered list of preferred RDS DB instance engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     */
    @JvmName("swtvegqcjfixwixp")
    public suspend fun preferredEngineVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredEngineVersions = mapped
    }

    /**
     * @param value Ordered list of preferred RDS DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     */
    @JvmName("espxaddvcmgywuxh")
    public suspend fun preferredInstanceClasses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredInstanceClasses = mapped
    }

    /**
     * @param values Ordered list of preferred RDS DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     */
    @JvmName("gfsxitifuvraakkm")
    public suspend fun preferredInstanceClasses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredInstanceClasses = mapped
    }

    /**
     * @param value Storage types. Examples of storage types are `standard`, `io1`, `gp2`, and `aurora`.
     */
    @JvmName("yhhmobdnpfvmwwrp")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.storageType = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
     */
    @JvmName("wwybmxxiwswexxba")
    public suspend fun supportsEnhancedMonitoring(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsEnhancedMonitoring = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports Aurora global databases with a specific combination of other DB engine attributes.
     */
    @JvmName("petngofvspqmbjfg")
    public suspend fun supportsGlobalDatabases(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsGlobalDatabases = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports IAM database authentication.
     */
    @JvmName("rmrwnfxnnmbbgqwi")
    public suspend fun supportsIamDatabaseAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsIamDatabaseAuthentication = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports provisioned IOPS.
     */
    @JvmName("etfphbmtafhwxmoj")
    public suspend fun supportsIops(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsIops = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports Kerberos Authentication.
     */
    @JvmName("tfgljfvneibebgwf")
    public suspend fun supportsKerberosAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsKerberosAuthentication = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports Performance Insights.
     */
    @JvmName("tugapbryhdhhrmgx")
    public suspend fun supportsPerformanceInsights(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsPerformanceInsights = mapped
    }

    /**
     * @param value Enable this to ensure Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
     */
    @JvmName("vxnmusaibacxfeak")
    public suspend fun supportsStorageAutoscaling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsStorageAutoscaling = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports encrypted storage.
     */
    @JvmName("dcyqebsntlmhpinb")
    public suspend fun supportsStorageEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsStorageEncryption = mapped
    }

    /**
     * @param value Boolean that indicates whether to show only VPC or non-VPC offerings.
     */
    @JvmName("qjtlfxiihyqcyrop")
    public suspend fun vpc(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpc = mapped
    }

    internal fun build(): GetOrderableDbInstancePlainArgs = GetOrderableDbInstancePlainArgs(
        availabilityZoneGroup = availabilityZoneGroup,
        engine = engine ?: throw PulumiNullFieldException("engine"),
        engineVersion = engineVersion,
        instanceClass = instanceClass,
        licenseModel = licenseModel,
        preferredEngineVersions = preferredEngineVersions,
        preferredInstanceClasses = preferredInstanceClasses,
        storageType = storageType,
        supportsEnhancedMonitoring = supportsEnhancedMonitoring,
        supportsGlobalDatabases = supportsGlobalDatabases,
        supportsIamDatabaseAuthentication = supportsIamDatabaseAuthentication,
        supportsIops = supportsIops,
        supportsKerberosAuthentication = supportsKerberosAuthentication,
        supportsPerformanceInsights = supportsPerformanceInsights,
        supportsStorageAutoscaling = supportsStorageAutoscaling,
        supportsStorageEncryption = supportsStorageEncryption,
        vpc = vpc,
    )
}
