@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetSnapshotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSnapshot.
 * @property dbInstanceIdentifier Returns the list of snapshots created by the specific db_instance
 * @property dbSnapshotIdentifier Returns information on a specific snapshot_id.
 * @property includePublic Set this value to true to include manual DB snapshots that are public and can be
 * copied or restored by any AWS account, otherwise set this value to false. The default is `false`.
 * @property includeShared Set this value to true to include shared manual DB snapshots from other
 * AWS accounts that this AWS account has been given permission to copy or restore, otherwise set this value to false.
 * The default is `false`.
 * @property mostRecent If more than one result is returned, use the most
 * recent Snapshot.
 * @property snapshotType Type of snapshots to be returned. If you don't specify a SnapshotType
 * value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not
 * included in the returned results by default. Possible values are, `automated`, `manual`, `shared`, `public` and `awsbackup`.
 * @property tags Mapping of tags, each pair of which must exactly match
 * a pair on the desired DB snapshot.
 */
public data class GetSnapshotPlainArgs(
    public val dbInstanceIdentifier: String? = null,
    public val dbSnapshotIdentifier: String? = null,
    public val includePublic: Boolean? = null,
    public val includeShared: Boolean? = null,
    public val mostRecent: Boolean? = null,
    public val snapshotType: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetSnapshotPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetSnapshotPlainArgs =
        com.pulumi.aws.rds.inputs.GetSnapshotPlainArgs.builder()
            .dbInstanceIdentifier(dbInstanceIdentifier?.let({ args0 -> args0 }))
            .dbSnapshotIdentifier(dbSnapshotIdentifier?.let({ args0 -> args0 }))
            .includePublic(includePublic?.let({ args0 -> args0 }))
            .includeShared(includeShared?.let({ args0 -> args0 }))
            .mostRecent(mostRecent?.let({ args0 -> args0 }))
            .snapshotType(snapshotType?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSnapshotPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotPlainArgsBuilder internal constructor() {
    private var dbInstanceIdentifier: String? = null

    private var dbSnapshotIdentifier: String? = null

    private var includePublic: Boolean? = null

    private var includeShared: Boolean? = null

    private var mostRecent: Boolean? = null

    private var snapshotType: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Returns the list of snapshots created by the specific db_instance
     */
    @JvmName("oytnvfpujpptgagl")
    public suspend fun dbInstanceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceIdentifier = mapped
    }

    /**
     * @param value Returns information on a specific snapshot_id.
     */
    @JvmName("dajwwvbjyqauranc")
    public suspend fun dbSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbSnapshotIdentifier = mapped
    }

    /**
     * @param value Set this value to true to include manual DB snapshots that are public and can be
     * copied or restored by any AWS account, otherwise set this value to false. The default is `false`.
     */
    @JvmName("ysguylaxwogcbkwx")
    public suspend fun includePublic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includePublic = mapped
    }

    /**
     * @param value Set this value to true to include shared manual DB snapshots from other
     * AWS accounts that this AWS account has been given permission to copy or restore, otherwise set this value to false.
     * The default is `false`.
     */
    @JvmName("fpjnscdfqkpgwxpt")
    public suspend fun includeShared(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeShared = mapped
    }

    /**
     * @param value If more than one result is returned, use the most
     * recent Snapshot.
     */
    @JvmName("sinvjnsphsyqhhip")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    /**
     * @param value Type of snapshots to be returned. If you don't specify a SnapshotType
     * value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not
     * included in the returned results by default. Possible values are, `automated`, `manual`, `shared`, `public` and `awsbackup`.
     */
    @JvmName("rjytwjjavkvptknw")
    public suspend fun snapshotType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotType = mapped
    }

    /**
     * @param value Mapping of tags, each pair of which must exactly match
     * a pair on the desired DB snapshot.
     */
    @JvmName("kvaqpqkhedfipffi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags, each pair of which must exactly match
     * a pair on the desired DB snapshot.
     */
    @JvmName("wlnqstixvgnubkdk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSnapshotPlainArgs = GetSnapshotPlainArgs(
        dbInstanceIdentifier = dbInstanceIdentifier,
        dbSnapshotIdentifier = dbSnapshotIdentifier,
        includePublic = includePublic,
        includeShared = includeShared,
        mostRecent = mostRecent,
        snapshotType = snapshotType,
        tags = tags,
    )
}
