@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetSubnetGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSubnetGroup.
 * @property name Name of the RDS database subnet group.
 */
public data class GetSubnetGroupPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetSubnetGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetSubnetGroupPlainArgs =
        com.pulumi.aws.rds.inputs.GetSubnetGroupPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubnetGroupPlainArgs].
 */
@PulumiTagMarker
public class GetSubnetGroupPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the RDS database subnet group.
     */
    @JvmName("xjjoudkpbynqprjx")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetSubnetGroupPlainArgs = GetSubnetGroupPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
