@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.InstanceRestoreToPointInTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property restoreTime The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
 * @property sourceDbInstanceAutomatedBackupsArn The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
 * @property sourceDbInstanceIdentifier The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
 * @property sourceDbiResourceId The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
 * @property useLatestRestorableTime A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
 */
public data class InstanceRestoreToPointInTimeArgs(
    public val restoreTime: Output<String>? = null,
    public val sourceDbInstanceAutomatedBackupsArn: Output<String>? = null,
    public val sourceDbInstanceIdentifier: Output<String>? = null,
    public val sourceDbiResourceId: Output<String>? = null,
    public val useLatestRestorableTime: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.InstanceRestoreToPointInTimeArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.InstanceRestoreToPointInTimeArgs =
        com.pulumi.aws.rds.inputs.InstanceRestoreToPointInTimeArgs.builder()
            .restoreTime(restoreTime?.applyValue({ args0 -> args0 }))
            .sourceDbInstanceAutomatedBackupsArn(
                sourceDbInstanceAutomatedBackupsArn?.applyValue({ args0 ->
                    args0
                }),
            )
            .sourceDbInstanceIdentifier(sourceDbInstanceIdentifier?.applyValue({ args0 -> args0 }))
            .sourceDbiResourceId(sourceDbiResourceId?.applyValue({ args0 -> args0 }))
            .useLatestRestorableTime(useLatestRestorableTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceRestoreToPointInTimeArgs].
 */
@PulumiTagMarker
public class InstanceRestoreToPointInTimeArgsBuilder internal constructor() {
    private var restoreTime: Output<String>? = null

    private var sourceDbInstanceAutomatedBackupsArn: Output<String>? = null

    private var sourceDbInstanceIdentifier: Output<String>? = null

    private var sourceDbiResourceId: Output<String>? = null

    private var useLatestRestorableTime: Output<Boolean>? = null

    /**
     * @param value The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
     */
    @JvmName("bnchfsdumlppaatx")
    public suspend fun restoreTime(`value`: Output<String>) {
        this.restoreTime = value
    }

    /**
     * @param value The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
     */
    @JvmName("xjlbgtjpalwlyvbp")
    public suspend fun sourceDbInstanceAutomatedBackupsArn(`value`: Output<String>) {
        this.sourceDbInstanceAutomatedBackupsArn = value
    }

    /**
     * @param value The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
     */
    @JvmName("nojiqqkvajwqqrpg")
    public suspend fun sourceDbInstanceIdentifier(`value`: Output<String>) {
        this.sourceDbInstanceIdentifier = value
    }

    /**
     * @param value The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
     */
    @JvmName("xaqxcpcsmbuwbgpp")
    public suspend fun sourceDbiResourceId(`value`: Output<String>) {
        this.sourceDbiResourceId = value
    }

    /**
     * @param value A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
     */
    @JvmName("nclaiedjgojfriic")
    public suspend fun useLatestRestorableTime(`value`: Output<Boolean>) {
        this.useLatestRestorableTime = value
    }

    /**
     * @param value The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
     */
    @JvmName("qtepuxlagldwvvck")
    public suspend fun restoreTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreTime = mapped
    }

    /**
     * @param value The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
     */
    @JvmName("oxghtsaemuenpkvh")
    public suspend fun sourceDbInstanceAutomatedBackupsArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbInstanceAutomatedBackupsArn = mapped
    }

    /**
     * @param value The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
     */
    @JvmName("toykedwtrojlsejj")
    public suspend fun sourceDbInstanceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbInstanceIdentifier = mapped
    }

    /**
     * @param value The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
     */
    @JvmName("skilcskldsdvfegd")
    public suspend fun sourceDbiResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbiResourceId = mapped
    }

    /**
     * @param value A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
     */
    @JvmName("tjumfedcyhbpovnf")
    public suspend fun useLatestRestorableTime(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useLatestRestorableTime = mapped
    }

    internal fun build(): InstanceRestoreToPointInTimeArgs = InstanceRestoreToPointInTimeArgs(
        restoreTime = restoreTime,
        sourceDbInstanceAutomatedBackupsArn = sourceDbInstanceAutomatedBackupsArn,
        sourceDbInstanceIdentifier = sourceDbInstanceIdentifier,
        sourceDbiResourceId = sourceDbiResourceId,
        useLatestRestorableTime = useLatestRestorableTime,
    )
}
