@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.OptionGroupOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dbSecurityGroupMemberships List of DB Security Groups for which the option is enabled.
 * @property optionName Name of the option (e.g., MEMCACHED).
 * @property optionSettings List of option settings to apply.
 * @property port Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
 * @property version Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
 * @property vpcSecurityGroupMemberships List of VPC Security Groups for which the option is enabled.
 */
public data class OptionGroupOptionArgs(
    public val dbSecurityGroupMemberships: Output<List<String>>? = null,
    public val optionName: Output<String>,
    public val optionSettings: Output<List<OptionGroupOptionOptionSettingArgs>>? = null,
    public val port: Output<Int>? = null,
    public val version: Output<String>? = null,
    public val vpcSecurityGroupMemberships: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.OptionGroupOptionArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.OptionGroupOptionArgs =
        com.pulumi.aws.rds.inputs.OptionGroupOptionArgs.builder()
            .dbSecurityGroupMemberships(
                dbSecurityGroupMemberships?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .optionName(optionName.applyValue({ args0 -> args0 }))
            .optionSettings(
                optionSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .vpcSecurityGroupMemberships(
                vpcSecurityGroupMemberships?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [OptionGroupOptionArgs].
 */
@PulumiTagMarker
public class OptionGroupOptionArgsBuilder internal constructor() {
    private var dbSecurityGroupMemberships: Output<List<String>>? = null

    private var optionName: Output<String>? = null

    private var optionSettings: Output<List<OptionGroupOptionOptionSettingArgs>>? = null

    private var port: Output<Int>? = null

    private var version: Output<String>? = null

    private var vpcSecurityGroupMemberships: Output<List<String>>? = null

    /**
     * @param value List of DB Security Groups for which the option is enabled.
     */
    @JvmName("tmawkwksnrrbfyie")
    public suspend fun dbSecurityGroupMemberships(`value`: Output<List<String>>) {
        this.dbSecurityGroupMemberships = value
    }

    @JvmName("mldpbylpnuggldql")
    public suspend fun dbSecurityGroupMemberships(vararg values: Output<String>) {
        this.dbSecurityGroupMemberships = Output.all(values.asList())
    }

    /**
     * @param values List of DB Security Groups for which the option is enabled.
     */
    @JvmName("enborppgbshehpls")
    public suspend fun dbSecurityGroupMemberships(values: List<Output<String>>) {
        this.dbSecurityGroupMemberships = Output.all(values)
    }

    /**
     * @param value Name of the option (e.g., MEMCACHED).
     */
    @JvmName("sjkithswpwqcxeri")
    public suspend fun optionName(`value`: Output<String>) {
        this.optionName = value
    }

    /**
     * @param value List of option settings to apply.
     */
    @JvmName("wuysidrxamsgncxn")
    public suspend fun optionSettings(`value`: Output<List<OptionGroupOptionOptionSettingArgs>>) {
        this.optionSettings = value
    }

    @JvmName("etquahcsicxhgmpg")
    public suspend fun optionSettings(vararg values: Output<OptionGroupOptionOptionSettingArgs>) {
        this.optionSettings = Output.all(values.asList())
    }

    /**
     * @param values List of option settings to apply.
     */
    @JvmName("vsatqfntbtnfugpl")
    public suspend fun optionSettings(values: List<Output<OptionGroupOptionOptionSettingArgs>>) {
        this.optionSettings = Output.all(values)
    }

    /**
     * @param value Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
     */
    @JvmName("edggtxmjtyvayxkx")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
     */
    @JvmName("iovpqwloeotxfnmy")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value List of VPC Security Groups for which the option is enabled.
     */
    @JvmName("eotnjldmbynxbsdi")
    public suspend fun vpcSecurityGroupMemberships(`value`: Output<List<String>>) {
        this.vpcSecurityGroupMemberships = value
    }

    @JvmName("ictxbkqsxfndmdhd")
    public suspend fun vpcSecurityGroupMemberships(vararg values: Output<String>) {
        this.vpcSecurityGroupMemberships = Output.all(values.asList())
    }

    /**
     * @param values List of VPC Security Groups for which the option is enabled.
     */
    @JvmName("gxbcgqgrrfdmdujj")
    public suspend fun vpcSecurityGroupMemberships(values: List<Output<String>>) {
        this.vpcSecurityGroupMemberships = Output.all(values)
    }

    /**
     * @param value List of DB Security Groups for which the option is enabled.
     */
    @JvmName("cfjccqnvhowsgrnq")
    public suspend fun dbSecurityGroupMemberships(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbSecurityGroupMemberships = mapped
    }

    /**
     * @param values List of DB Security Groups for which the option is enabled.
     */
    @JvmName("kermvpychgmbwnay")
    public suspend fun dbSecurityGroupMemberships(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbSecurityGroupMemberships = mapped
    }

    /**
     * @param value Name of the option (e.g., MEMCACHED).
     */
    @JvmName("hqguhjvmbqiuggky")
    public suspend fun optionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optionName = mapped
    }

    /**
     * @param value List of option settings to apply.
     */
    @JvmName("imrakyuykgpevkae")
    public suspend fun optionSettings(`value`: List<OptionGroupOptionOptionSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionSettings = mapped
    }

    /**
     * @param argument List of option settings to apply.
     */
    @JvmName("kxixldxwhjucyxdq")
    public suspend
    fun optionSettings(argument: List<suspend OptionGroupOptionOptionSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OptionGroupOptionOptionSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.optionSettings = mapped
    }

    /**
     * @param argument List of option settings to apply.
     */
    @JvmName("lbykeewdoshxbjum")
    public suspend fun optionSettings(
        vararg
        argument: suspend OptionGroupOptionOptionSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            OptionGroupOptionOptionSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.optionSettings = mapped
    }

    /**
     * @param argument List of option settings to apply.
     */
    @JvmName("vsepcapcclegqoau")
    public suspend
    fun optionSettings(argument: suspend OptionGroupOptionOptionSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            OptionGroupOptionOptionSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.optionSettings = mapped
    }

    /**
     * @param values List of option settings to apply.
     */
    @JvmName("qewjlnqtowkhubbe")
    public suspend fun optionSettings(vararg values: OptionGroupOptionOptionSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optionSettings = mapped
    }

    /**
     * @param value Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
     */
    @JvmName("plrgpkfsjajosucj")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
     */
    @JvmName("donkgqwlihoxuifl")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value List of VPC Security Groups for which the option is enabled.
     */
    @JvmName("neugifcddwusirpm")
    public suspend fun vpcSecurityGroupMemberships(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupMemberships = mapped
    }

    /**
     * @param values List of VPC Security Groups for which the option is enabled.
     */
    @JvmName("imahjtnxosvmdbcx")
    public suspend fun vpcSecurityGroupMemberships(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupMemberships = mapped
    }

    internal fun build(): OptionGroupOptionArgs = OptionGroupOptionArgs(
        dbSecurityGroupMemberships = dbSecurityGroupMemberships,
        optionName = optionName ?: throw PulumiNullFieldException("optionName"),
        optionSettings = optionSettings,
        port = port,
        version = version,
        vpcSecurityGroupMemberships = vpcSecurityGroupMemberships,
    )
}
