@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.OptionGroupOptionOptionSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the setting.
 * @property value Value of the setting.
 */
public data class OptionGroupOptionOptionSettingArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.OptionGroupOptionOptionSettingArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.OptionGroupOptionOptionSettingArgs =
        com.pulumi.aws.rds.inputs.OptionGroupOptionOptionSettingArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OptionGroupOptionOptionSettingArgs].
 */
@PulumiTagMarker
public class OptionGroupOptionOptionSettingArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the setting.
     */
    @JvmName("ijewtyljvvlsxhct")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value of the setting.
     */
    @JvmName("bynepxydjkbqlgrs")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the setting.
     */
    @JvmName("mdplpwnnvbnpvygs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value of the setting.
     */
    @JvmName("enirkytbwuluvuth")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): OptionGroupOptionOptionSettingArgs = OptionGroupOptionOptionSettingArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
