@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
 * @property secretArn Amazon Resource Name (ARN) of the secret.
 * @property secretStatus Status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
 */
public data class ClusterMasterUserSecret(
    public val kmsKeyId: String? = null,
    public val secretArn: String? = null,
    public val secretStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.ClusterMasterUserSecret):
            ClusterMasterUserSecret = ClusterMasterUserSecret(
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            secretArn = javaType.secretArn().map({ args0 -> args0 }).orElse(null),
            secretStatus = javaType.secretStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
