@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property maxCapacity Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
 * @property minCapacity Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
 */
public data class ClusterServerlessv2ScalingConfiguration(
    public val maxCapacity: Double,
    public val minCapacity: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.rds.outputs.ClusterServerlessv2ScalingConfiguration):
            ClusterServerlessv2ScalingConfiguration = ClusterServerlessv2ScalingConfiguration(
            maxCapacity = javaType.maxCapacity(),
            minCapacity = javaType.minCapacity(),
        )
    }
}
