@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getCertificate.
 * @property arn ARN of the certificate.
 * @property certificateType Type of certificate. For example, `CA`.
 * @property customerOverride Boolean whether there is an override for the default certificate identifier.
 * @property customerOverrideValidTill If there is an override for the default certificate identifier, when the override expires.
 * @property id
 * @property latestValidTill
 * @property thumbprint Thumbprint of the certificate.
 * @property validFrom [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of certificate starting validity date.
 * @property validTill [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of certificate ending validity date.
 */
public data class GetCertificateResult(
    public val arn: String,
    public val certificateType: String,
    public val customerOverride: Boolean,
    public val customerOverrideValidTill: String,
    public val id: String,
    public val latestValidTill: Boolean? = null,
    public val thumbprint: String,
    public val validFrom: String,
    public val validTill: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetCertificateResult):
            GetCertificateResult = GetCertificateResult(
            arn = javaType.arn(),
            certificateType = javaType.certificateType(),
            customerOverride = javaType.customerOverride(),
            customerOverrideValidTill = javaType.customerOverrideValidTill(),
            id = javaType.id(),
            latestValidTill = javaType.latestValidTill().map({ args0 -> args0 }).orElse(null),
            thumbprint = javaType.thumbprint(),
            validFrom = javaType.validFrom(),
            validTill = javaType.validTill(),
        )
    }
}
