@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEngineVersion.
 * @property defaultCharacterSet The default character set for new instances of this engine version.
 * @property defaultOnly
 * @property engine
 * @property engineDescription Description of the database engine.
 * @property exportableLogTypes Set of log types that the database engine has available for export to CloudWatch Logs.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property includeAll
 * @property parameterGroupFamily
 * @property preferredVersions
 * @property status Status of the DB engine version, either available or deprecated.
 * @property supportedCharacterSets Set of the character sets supported by this engine.
 * @property supportedFeatureNames Set of features supported by the DB engine.
 * @property supportedModes Set of the supported DB engine modes.
 * @property supportedTimezones Set of the time zones supported by this engine.
 * @property supportsGlobalDatabases Indicates whether you can use Aurora global databases with a specific DB engine version.
 * @property supportsLogExportsToCloudwatch Indicates whether the engine version supports exporting the log types specified by `exportable_log_types` to CloudWatch Logs.
 * @property supportsParallelQuery Indicates whether you can use Aurora parallel query with a specific DB engine version.
 * @property supportsReadReplica Indicates whether the database engine version supports read replicas.
 * @property validUpgradeTargets Set of engine versions that this database engine version can be upgraded to.
 * @property version
 * @property versionDescription Description of the database engine version.
 */
public data class GetEngineVersionResult(
    public val defaultCharacterSet: String,
    public val defaultOnly: Boolean? = null,
    public val engine: String,
    public val engineDescription: String,
    public val exportableLogTypes: List<String>,
    public val filters: List<GetEngineVersionFilter>? = null,
    public val id: String,
    public val includeAll: Boolean? = null,
    public val parameterGroupFamily: String,
    public val preferredVersions: List<String>? = null,
    public val status: String,
    public val supportedCharacterSets: List<String>,
    public val supportedFeatureNames: List<String>,
    public val supportedModes: List<String>,
    public val supportedTimezones: List<String>,
    public val supportsGlobalDatabases: Boolean,
    public val supportsLogExportsToCloudwatch: Boolean,
    public val supportsParallelQuery: Boolean,
    public val supportsReadReplica: Boolean,
    public val validUpgradeTargets: List<String>,
    public val version: String,
    public val versionDescription: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetEngineVersionResult):
            GetEngineVersionResult = GetEngineVersionResult(
            defaultCharacterSet = javaType.defaultCharacterSet(),
            defaultOnly = javaType.defaultOnly().map({ args0 -> args0 }).orElse(null),
            engine = javaType.engine(),
            engineDescription = javaType.engineDescription(),
            exportableLogTypes = javaType.exportableLogTypes().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.rds.kotlin.outputs.GetEngineVersionFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            includeAll = javaType.includeAll().map({ args0 -> args0 }).orElse(null),
            parameterGroupFamily = javaType.parameterGroupFamily(),
            preferredVersions = javaType.preferredVersions().map({ args0 -> args0 }),
            status = javaType.status(),
            supportedCharacterSets = javaType.supportedCharacterSets().map({ args0 -> args0 }),
            supportedFeatureNames = javaType.supportedFeatureNames().map({ args0 -> args0 }),
            supportedModes = javaType.supportedModes().map({ args0 -> args0 }),
            supportedTimezones = javaType.supportedTimezones().map({ args0 -> args0 }),
            supportsGlobalDatabases = javaType.supportsGlobalDatabases(),
            supportsLogExportsToCloudwatch = javaType.supportsLogExportsToCloudwatch(),
            supportsParallelQuery = javaType.supportsParallelQuery(),
            supportsReadReplica = javaType.supportsReadReplica(),
            validUpgradeTargets = javaType.validUpgradeTargets().map({ args0 -> args0 }),
            version = javaType.version(),
            versionDescription = javaType.versionDescription(),
        )
    }
}
