@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs&#46;aws&#46;amazon&#46;com/AmazonRDS/latest/APIReference/API_DescribeDBClusters&#46;html) or [RDS DescribeDBInstances API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html).
 * @property values Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
 */
public data class GetInstancesFilter(
    public val name: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetInstancesFilter): GetInstancesFilter =
            GetInstancesFilter(
                name = javaType.name(),
                values = javaType.values().map({ args0 -> args0 }),
            )
    }
}
