@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getSnapshot.
 * @property allocatedStorage Allocated storage size in gigabytes (GB).
 * @property availabilityZone Name of the Availability Zone the DB instance was located in at the time of the DB snapshot.
 * @property dbInstanceIdentifier
 * @property dbSnapshotArn ARN for the DB snapshot.
 * @property dbSnapshotIdentifier
 * @property encrypted Whether the DB snapshot is encrypted.
 * @property engine Name of the database engine.
 * @property engineVersion Version of the database engine.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property includePublic
 * @property includeShared
 * @property iops Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
 * @property kmsKeyId ARN for the KMS encryption key.
 * @property licenseModel License model information for the restored DB instance.
 * @property mostRecent
 * @property optionGroupName Provides the option group name for the DB snapshot.
 * @property port
 * @property snapshotCreateTime Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).
 * @property snapshotType
 * @property sourceDbSnapshotIdentifier DB snapshot ARN that the DB snapshot was copied from. It only has value in case of cross customer or cross region copy.
 * @property sourceRegion Region that the DB snapshot was created in or copied from.
 * @property status Status of this DB snapshot.
 * @property storageType Storage type associated with DB snapshot.
 * @property tags
 * @property vpcId ID of the VPC associated with the DB snapshot.
 */
public data class GetSnapshotResult(
    public val allocatedStorage: Int,
    public val availabilityZone: String,
    public val dbInstanceIdentifier: String? = null,
    public val dbSnapshotArn: String,
    public val dbSnapshotIdentifier: String? = null,
    public val encrypted: Boolean,
    public val engine: String,
    public val engineVersion: String,
    public val id: String,
    public val includePublic: Boolean? = null,
    public val includeShared: Boolean? = null,
    public val iops: Int,
    public val kmsKeyId: String,
    public val licenseModel: String,
    public val mostRecent: Boolean? = null,
    public val optionGroupName: String,
    public val port: Int,
    public val snapshotCreateTime: String,
    public val snapshotType: String? = null,
    public val sourceDbSnapshotIdentifier: String,
    public val sourceRegion: String,
    public val status: String,
    public val storageType: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetSnapshotResult): GetSnapshotResult =
            GetSnapshotResult(
                allocatedStorage = javaType.allocatedStorage(),
                availabilityZone = javaType.availabilityZone(),
                dbInstanceIdentifier = javaType.dbInstanceIdentifier().map({ args0 -> args0 }).orElse(null),
                dbSnapshotArn = javaType.dbSnapshotArn(),
                dbSnapshotIdentifier = javaType.dbSnapshotIdentifier().map({ args0 -> args0 }).orElse(null),
                encrypted = javaType.encrypted(),
                engine = javaType.engine(),
                engineVersion = javaType.engineVersion(),
                id = javaType.id(),
                includePublic = javaType.includePublic().map({ args0 -> args0 }).orElse(null),
                includeShared = javaType.includeShared().map({ args0 -> args0 }).orElse(null),
                iops = javaType.iops(),
                kmsKeyId = javaType.kmsKeyId(),
                licenseModel = javaType.licenseModel(),
                mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
                optionGroupName = javaType.optionGroupName(),
                port = javaType.port(),
                snapshotCreateTime = javaType.snapshotCreateTime(),
                snapshotType = javaType.snapshotType().map({ args0 -> args0 }).orElse(null),
                sourceDbSnapshotIdentifier = javaType.sourceDbSnapshotIdentifier(),
                sourceRegion = javaType.sourceRegion(),
                status = javaType.status(),
                storageType = javaType.storageType(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                vpcId = javaType.vpcId(),
            )
    }
}
