@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSubnetGroup.
 * @property arn ARN for the DB subnet group.
 * @property description Provides the description of the DB subnet group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property status Provides the status of the DB subnet group.
 * @property subnetIds Contains a list of subnet identifiers.
 * @property supportedNetworkTypes The network type of the DB subnet group.
 * @property vpcId Provides the VPC ID of the DB subnet group.
 */
public data class GetSubnetGroupResult(
    public val arn: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val status: String,
    public val subnetIds: List<String>,
    public val supportedNetworkTypes: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetSubnetGroupResult):
            GetSubnetGroupResult = GetSubnetGroupResult(
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            status = javaType.status(),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            supportedNetworkTypes = javaType.supportedNetworkTypes().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
