@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property restoreTime The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
 * @property sourceDbInstanceAutomatedBackupsArn The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
 * @property sourceDbInstanceIdentifier The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
 * @property sourceDbiResourceId The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
 * @property useLatestRestorableTime A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
 */
public data class InstanceRestoreToPointInTime(
    public val restoreTime: String? = null,
    public val sourceDbInstanceAutomatedBackupsArn: String? = null,
    public val sourceDbInstanceIdentifier: String? = null,
    public val sourceDbiResourceId: String? = null,
    public val useLatestRestorableTime: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.InstanceRestoreToPointInTime):
            InstanceRestoreToPointInTime = InstanceRestoreToPointInTime(
            restoreTime = javaType.restoreTime().map({ args0 -> args0 }).orElse(null),
            sourceDbInstanceAutomatedBackupsArn = javaType.sourceDbInstanceAutomatedBackupsArn().map({ args0 ->
                args0
            }).orElse(null),
            sourceDbInstanceIdentifier = javaType.sourceDbInstanceIdentifier().map({ args0 ->
                args0
            }).orElse(null),
            sourceDbiResourceId = javaType.sourceDbiResourceId().map({ args0 -> args0 }).orElse(null),
            useLatestRestorableTime = javaType.useLatestRestorableTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
