@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dbSecurityGroupMemberships List of DB Security Groups for which the option is enabled.
 * @property optionName Name of the option (e.g., MEMCACHED).
 * @property optionSettings List of option settings to apply.
 * @property port Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
 * @property version Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
 * @property vpcSecurityGroupMemberships List of VPC Security Groups for which the option is enabled.
 */
public data class OptionGroupOption(
    public val dbSecurityGroupMemberships: List<String>? = null,
    public val optionName: String,
    public val optionSettings: List<OptionGroupOptionOptionSetting>? = null,
    public val port: Int? = null,
    public val version: String? = null,
    public val vpcSecurityGroupMemberships: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.OptionGroupOption): OptionGroupOption =
            OptionGroupOption(
                dbSecurityGroupMemberships = javaType.dbSecurityGroupMemberships().map({ args0 -> args0 }),
                optionName = javaType.optionName(),
                optionSettings = javaType.optionSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.rds.kotlin.outputs.OptionGroupOptionOptionSetting.Companion.toKotlin(args0)
                    })
                }),
                port = javaType.port().map({ args0 -> args0 }).orElse(null),
                version = javaType.version().map({ args0 -> args0 }).orElse(null),
                vpcSecurityGroupMemberships = javaType.vpcSecurityGroupMemberships().map({ args0 -> args0 }),
            )
    }
}
