@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authScheme The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
 * @property clientPasswordAuthType The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
 * @property description A user-specified description about the authentication used by a proxy to log in as a specific database user.
 * @property iamAuth Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
 * @property secretArn The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
 * @property username The name of the database user to which the proxy connects.
 */
public data class ProxyAuth(
    public val authScheme: String? = null,
    public val clientPasswordAuthType: String? = null,
    public val description: String? = null,
    public val iamAuth: String? = null,
    public val secretArn: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.ProxyAuth): ProxyAuth = ProxyAuth(
            authScheme = javaType.authScheme().map({ args0 -> args0 }).orElse(null),
            clientPasswordAuthType = javaType.clientPasswordAuthType().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            iamAuth = javaType.iamAuth().map({ args0 -> args0 }).orElse(null),
            secretArn = javaType.secretArn().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
