@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AuthenticationProfile].
 */
@PulumiTagMarker
public class AuthenticationProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthenticationProfileArgs = AuthenticationProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthenticationProfileArgsBuilder.() -> Unit) {
        val builder = AuthenticationProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AuthenticationProfile {
        val builtJavaResource = com.pulumi.aws.redshift.AuthenticationProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AuthenticationProfile(builtJavaResource)
    }
}

/**
 * Creates a Redshift authentication profile
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.AuthenticationProfile;
 * import com.pulumi.aws.redshift.AuthenticationProfileArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AuthenticationProfile("example", AuthenticationProfileArgs.builder()
 *             .authenticationProfileName("example")
 *             .authenticationProfileContent(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("AllowDBUserOverride", "1"),
 *                     jsonProperty("Client_ID", "ExampleClientID"),
 *                     jsonProperty("App_ID", "example")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Authentication by `authentication_profile_name`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/authenticationProfile:AuthenticationProfile test example
 * ```
 *
 */
public class AuthenticationProfile internal constructor(
    override val javaResource: com.pulumi.aws.redshift.AuthenticationProfile,
) : KotlinCustomResource(javaResource, AuthenticationProfileMapper) {
    /**
     * The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
     */
    public val authenticationProfileContent: Output<String>
        get() = javaResource.authenticationProfileContent().applyValue({ args0 -> args0 })

    /**
     * The name of the authentication profile.
     */
    public val authenticationProfileName: Output<String>
        get() = javaResource.authenticationProfileName().applyValue({ args0 -> args0 })
}

public object AuthenticationProfileMapper : ResourceMapper<AuthenticationProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.AuthenticationProfile::class == javaResource::class

    override fun map(javaResource: Resource): AuthenticationProfile =
        AuthenticationProfile(javaResource as com.pulumi.aws.redshift.AuthenticationProfile)
}

/**
 * @see [AuthenticationProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AuthenticationProfile].
 */
public suspend fun authenticationProfile(
    name: String,
    block: suspend AuthenticationProfileResourceBuilder.() -> Unit,
): AuthenticationProfile {
    val builder = AuthenticationProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AuthenticationProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authenticationProfile(name: String): AuthenticationProfile {
    val builder = AuthenticationProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
