@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.AuthenticationProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a Redshift authentication profile
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.AuthenticationProfile;
 * import com.pulumi.aws.redshift.AuthenticationProfileArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AuthenticationProfile("example", AuthenticationProfileArgs.builder()
 *             .authenticationProfileName("example")
 *             .authenticationProfileContent(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("AllowDBUserOverride", "1"),
 *                     jsonProperty("Client_ID", "ExampleClientID"),
 *                     jsonProperty("App_ID", "example")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Authentication by `authentication_profile_name`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/authenticationProfile:AuthenticationProfile test example
 * ```
 * @property authenticationProfileContent The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
 * @property authenticationProfileName The name of the authentication profile.
 */
public data class AuthenticationProfileArgs(
    public val authenticationProfileContent: Output<String>? = null,
    public val authenticationProfileName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.AuthenticationProfileArgs> {
    override fun toJava(): com.pulumi.aws.redshift.AuthenticationProfileArgs =
        com.pulumi.aws.redshift.AuthenticationProfileArgs.builder()
            .authenticationProfileContent(authenticationProfileContent?.applyValue({ args0 -> args0 }))
            .authenticationProfileName(authenticationProfileName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthenticationProfileArgs].
 */
@PulumiTagMarker
public class AuthenticationProfileArgsBuilder internal constructor() {
    private var authenticationProfileContent: Output<String>? = null

    private var authenticationProfileName: Output<String>? = null

    /**
     * @param value The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
     */
    @JvmName("xergnlrsfjngbvxo")
    public suspend fun authenticationProfileContent(`value`: Output<String>) {
        this.authenticationProfileContent = value
    }

    /**
     * @param value The name of the authentication profile.
     */
    @JvmName("nkhbhrjesqkgsntw")
    public suspend fun authenticationProfileName(`value`: Output<String>) {
        this.authenticationProfileName = value
    }

    /**
     * @param value The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
     */
    @JvmName("npdvytfpgpsnxlnx")
    public suspend fun authenticationProfileContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationProfileContent = mapped
    }

    /**
     * @param value The name of the authentication profile.
     */
    @JvmName("rghvtskqklxehpbp")
    public suspend fun authenticationProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationProfileName = mapped
    }

    internal fun build(): AuthenticationProfileArgs = AuthenticationProfileArgs(
        authenticationProfileContent = authenticationProfileContent,
        authenticationProfileName = authenticationProfileName,
    )
}
