@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.ClusterIamRolesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Redshift Cluster IAM Roles resource.
 * > **NOTE:** A Redshift cluster's default IAM role can be managed both by this resource's `default_iam_role_arn` argument and the `aws.redshift.Cluster` resource's `default_iam_role_arn` argument. Do not configure different values for both arguments. Doing so will cause a conflict of default IAM roles.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.ClusterIamRoles;
 * import com.pulumi.aws.redshift.ClusterIamRolesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterIamRoles("example", ClusterIamRolesArgs.builder()
 *             .clusterIdentifier(aws_redshift_cluster.example().cluster_identifier())
 *             .iamRoleArns(aws_iam_role.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Cluster IAM Roless using the `cluster_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/clusterIamRoles:ClusterIamRoles examplegroup1 example
 * ```
 * @property clusterIdentifier The name of the Redshift Cluster IAM Roles.
 * @property defaultIamRoleArn The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
 * @property iamRoleArns A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
 */
public data class ClusterIamRolesArgs(
    public val clusterIdentifier: Output<String>? = null,
    public val defaultIamRoleArn: Output<String>? = null,
    public val iamRoleArns: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.ClusterIamRolesArgs> {
    override fun toJava(): com.pulumi.aws.redshift.ClusterIamRolesArgs =
        com.pulumi.aws.redshift.ClusterIamRolesArgs.builder()
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .defaultIamRoleArn(defaultIamRoleArn?.applyValue({ args0 -> args0 }))
            .iamRoleArns(iamRoleArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ClusterIamRolesArgs].
 */
@PulumiTagMarker
public class ClusterIamRolesArgsBuilder internal constructor() {
    private var clusterIdentifier: Output<String>? = null

    private var defaultIamRoleArn: Output<String>? = null

    private var iamRoleArns: Output<List<String>>? = null

    /**
     * @param value The name of the Redshift Cluster IAM Roles.
     */
    @JvmName("ynqexsfxoawqlxfk")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
     */
    @JvmName("snhwkqqcrkgreoow")
    public suspend fun defaultIamRoleArn(`value`: Output<String>) {
        this.defaultIamRoleArn = value
    }

    /**
     * @param value A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     */
    @JvmName("rfrahtfnxpsrohbu")
    public suspend fun iamRoleArns(`value`: Output<List<String>>) {
        this.iamRoleArns = value
    }

    @JvmName("ekmoaagkngsnidai")
    public suspend fun iamRoleArns(vararg values: Output<String>) {
        this.iamRoleArns = Output.all(values.asList())
    }

    /**
     * @param values A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     */
    @JvmName("wqdkjpvdvyvqerym")
    public suspend fun iamRoleArns(values: List<Output<String>>) {
        this.iamRoleArns = Output.all(values)
    }

    /**
     * @param value The name of the Redshift Cluster IAM Roles.
     */
    @JvmName("nhjsxbiwxmbayvum")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
     */
    @JvmName("sbqrdibsxiaxvubt")
    public suspend fun defaultIamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultIamRoleArn = mapped
    }

    /**
     * @param value A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     */
    @JvmName("bbagcgeyimevaiap")
    public suspend fun iamRoleArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArns = mapped
    }

    /**
     * @param values A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     */
    @JvmName("ddlkicnapmcxpmdi")
    public suspend fun iamRoleArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iamRoleArns = mapped
    }

    internal fun build(): ClusterIamRolesArgs = ClusterIamRolesArgs(
        clusterIdentifier = clusterIdentifier,
        defaultIamRoleArn = defaultIamRoleArn,
        iamRoleArns = iamRoleArns,
    )
}
